/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist;

import java.io.Serializable;

import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.actionlist.web.ActionListAction;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;


/**
 * An attribute which allows for the Action List to be customized to provide
 * Mass Actions and an internal frame for displaying a summary view of the
 * document on each row in the Action List.
 *
 * @see ActionListAction
 * @see DefaultCustomActionListAttribute
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CustomActionListAttribute extends Serializable {

	/**
	 * Returns the set of legal actions for this Action List attribute.  This set of actions dictates
	 * which actions can be taken on the document from the ActionList.  If this method returns null then
	 * action invocation will not be available from the action list.
	 */
	public ActionSet getLegalActions(String principalId, ActionItem actionItem) throws Exception;

	/**
	 * Returns the display parameters for the inline framed doc handler on the Action List.
	 * If this method returns null, then a default value will be used.
	 */
	public DisplayParameters getDocHandlerDisplayParameters(String principalId, ActionItem actionItem) throws Exception;

}
