/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notes;

import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.krad.UserSession;


/**
 * An attribute which allows for customization of the Notes interface for
 * a particular document.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CustomNoteAttribute {

    public boolean isAuthorizedToEditNote(Note note) throws Exception;
    public boolean isAuthorizedToAddNotes() throws Exception;
    public boolean isAuthorizedToRetrieveAttachments() throws Exception;
    public Document getRouteHeaderVO();
    public void setRouteHeaderVO(Document routeHeaderVO);
    public UserSession getUserSession();
    public void setUserSession(UserSession workflowUserSession);
    
}
