/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notes.web;

import java.util.List;

import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kns.web.struts.form.KualiForm;

/**
 * Struts ActionForm for {@link NoteAction}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NoteForm extends KualiForm {

	private static final long serialVersionUID = 1L;
	private Note note;
    private Note existingNote;
    private String methodToCall = "";
    private String showEdit;
    private Boolean showAdd;
    private String docId;
    private String noteIdNumber;
    private Integer numberOfNotes;
    private String sortOrder = "DESCENDING";
    private Boolean sortNotes;
    private String currentUserName;
    private String currentDate;
    private Boolean authorizedToAdd;
    private List<Note> noteList;
    private String addText;
    private Long idInEdit;
    private Boolean showAttachments;
    private String attachmentTarget;


    private Object file;

    public NoteForm() {
        note = new Note();
    }

    @Override
    public String getMethodToCall() {
        return methodToCall;
    }

    @Override
    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public Note getNote() {
        return note;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    public Note getExistingNote() {
        return existingNote;
    }

    public void setExistingNote(Note existingNote) {
        this.existingNote = existingNote;
    }

    public String getShowEdit() {
        return showEdit;
    }

    public void setShowEdit(String showEdit) {
        this.showEdit = showEdit;
    }

    public String getDocId() {
        return docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public Integer getNumberOfNotes() {
        return numberOfNotes;
    }

    public void setNumberOfNotes(Integer numberOfNotes) {
        this.numberOfNotes = numberOfNotes;
    }

    public Boolean getShowAdd() {
        return showAdd;
    }

    public void setShowAdd(Boolean showAdd) {
        this.showAdd = showAdd;
    }

    public String getNoteIdNumber() {
        return noteIdNumber;
    }

    public void setNoteIdNumber(String noteIdNumber) {
        this.noteIdNumber = noteIdNumber;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Boolean getSortNotes() {
        return sortNotes;
    }

    public void setSortNotes(Boolean sortNotes) {
        this.sortNotes = sortNotes;
    }

    public String getCurrentDate() {
        return currentDate;
    }

    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    public String getCurrentUserName() {
        return currentUserName;
    }

    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    public Boolean getAuthorizedToAdd() {
        return authorizedToAdd;
    }

    public void setAuthorizedToAdd(Boolean authorizedToAdd) {
        this.authorizedToAdd = authorizedToAdd;
    }

    public List<Note> getNoteList() {
        return noteList;
    }

    public void setNoteList(List<Note> noteList) {
        this.noteList = noteList;
    }

    public String getAddText() {
        return addText;
    }

    public void setAddText(String addText) {
        this.addText = addText;
    }

    public Long getIdInEdit() {
        return idInEdit;
    }

    public void setIdInEdit(Long idInEdit) {
        this.idInEdit = idInEdit;
    }

	public Object getFile() {
		return file;
	}

	public void setFile(Object file) {
		this.file = file;
	}

	public Boolean getShowAttachments() {
		return showAttachments;
	}

	public void setShowAttachments(Boolean showAttachments) {
		this.showAttachments = showAttachments;
	}

	public String getAttachmentTarget() {
		return attachmentTarget;
	}

	public void setAttachmentTarget(String attachmentTarget) {
		this.attachmentTarget = attachmentTarget;
	}
}
