/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.util;

/**
 * This class houses various constants for KCB
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class KCBConstants {
	
	public static final String SERVICE_NAMESPACE = "KCB";
	
    /**
     * Different message delivers for KCB
     * DEFAULT_MESSAGE_DELIVERY_TYPE - the default message delivery type
     * @author Kuali Rice Team (rice.collab@kuali.org)
     */
    public static final class MESSAGE_DELIVERY_TYPES {
        public static final String EMAIL_MESSAGE_DELIVERY_TYPE = "Email"; 
        
    	private MESSAGE_DELIVERY_TYPES() {
    		throw new UnsupportedOperationException("do not call");
    	}
    }
    
	private KCBConstants() {
		throw new UnsupportedOperationException("do not call");
	}
}
