/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.var;

/**
 * Represents a property that can be accessed relative to a specific "scheme".
 * Property format: <code>[scheme:]locator</code>
 * <dl>
 *   <dt>scheme</dt>
 *   <dd>The "scheme" of the property, which is implemented by a PropertyScheme implementation to
 *       resolve the locator to an actual value</dd>
 *   <dt>locator</dt>
 *   <dd>PropertyScheme-implementation-specific property name or URI</dd>
 * </dl>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class Property {
    /**
     * The property scheme (e.g. var:, url:, file:
     */
    public String scheme;
    /**
     * The property locator; in the case of a variable it is a name; in the case of a url, a url;
     * in the case of a file, a file path
     */
    public String locator;

    /**
     * Parses the scheme and locator from a property name/locator string
     * @param string the property name/locator
     */
    public Property(String string) {
        int i = string.indexOf(':');
        if (i == -1) {
            locator = string;
        } else {
            if (i > 0) {
                scheme = string.substring(0, i);
            }
            locator = string.substring(i + 1);
        }
    }

    /**
     * Initialized the property with specified scheme and locator
     * @param scheme the scheme
     * @param locator the locator
     */
    public Property(String scheme, String locator) {
        this.scheme = scheme;
        this.locator = locator;
    }

    @Override
    public String toString() {
        return "[Property: scheme=" + scheme + ", locator=" + locator + "]";
    }
}
