/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.mail;

import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.Document;

/**
 * Application areas can implement this interface to generate custom email content.
 * 
 * At the point that getCustomEmailSubject() and getCustomEmailBody() are called, the
 * RouteHeaderVO and ActionRequestVO have already been set so the implementing class can
 * simply call the approriate getters to retrieve the data beans.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CustomEmailAttribute {

	/**
	 * Returns a String that will be appended to the standard email subject.
	 */
    public String getCustomEmailSubject() throws Exception;
    
    /**
     * Returns a String that will be appeneded to the standard email body.
     */
    public String getCustomEmailBody() throws Exception;
    
    /**
     * Gets the RouteHeaderVO bean which has document data 
     * @return
     */
    public Document getRouteHeaderVO();
    public void setRouteHeaderVO(Document routeHeaderVO);
    public ActionRequest getActionRequestVO();
    public void setActionRequestVO(ActionRequest actionRequestVO);
    
}
