/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.role;

import org.kuali.rice.kew.engine.RouteContext;

import java.util.List;
import java.util.Map;

/**
 * A QualifierResolver is responsible for resolving qualifiers that might be used
 * to identify a Qualified Role from a Document.  Information about the Document
 * can be obtained from the RouteContext.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface QualifierResolver {

	public List<Map<String, String>> resolve(RouteContext context);
	
}
