/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.rule.bo.RuleBaseValuesLookupableImpl;
import org.kuali.rice.kns.web.ui.Row;

import java.util.List;
import java.util.Map;

/**
 * An interface which can be implemented by a {@link WorkflowRuleAttribute} implementation which allows
 * a different List of {@link Row} objects to be returned for rendering on the rule lookup screen.
 * 
 * @see RuleBaseValuesLookupableImpl
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface WorkflowRuleSearchAttribute extends WorkflowRuleAttribute{

    /**
     * If your attribute is an OddSearchAttribute this method will be used to get search rows instead of the
     * usually called get RuleRows.  Generally this is used for Attributes that want to expose drop downs
     * for Rule Entry but need special wild card fields for searches that wouldn't work for rule entry.
     */
    List<Row> getSearchRows();
    
    /** 
     * validate search data and populate attribute with search data
     * @param paramMap
     * @return
     */
    List<RemotableAttributeError> validateSearchData(Map<String, String> paramMap);
    
}
