/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rules.ui;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.rule.event.ui.AddDelegationEvent;
import org.kuali.rice.kim.rule.ui.AddDelegationRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class RoleDocumentDelegationRule extends DocumentRuleBase implements AddDelegationRule {

	protected static final String ERROR_PATH = "permission.permissionId";
	
	@Override
    public boolean processAddDelegation(AddDelegationEvent addDelegationEvent) {
		RoleDocumentDelegation newDelegation = addDelegationEvent.getDelegation();
		boolean rulePassed = true;
		if (newDelegation == null || StringUtils.isBlank(newDelegation.getDelegationTypeCode())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(ERROR_PATH, RiceKeyConstants.ERROR_EMPTY_ENTRY, new String[] {"Permission"});
        }
		return rulePassed;
	} 

}
