/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.Transient;
import javax.xml.ws.WebServiceException;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kim.document.IdentityManagementKimDocument;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementTypeAttributeTransactionalDocument extends IdentityManagementKimDocument {

	protected static final long serialVersionUID = -9064436454008712125L;
	@Transient
	protected transient KimTypeService kimTypeService;
	@Transient
	protected KimType kimType;
	@Transient
	protected List<? extends KimAttributes> attributes;
	@Transient
	protected transient List<KimAttributeField> definitions;
	@Transient
	protected transient Map<String,Object> attributeEntry;
	
	/**
	 * @return the attributes
	 */
	public List<? extends KimAttributes> getAttributes() {
		return this.attributes;
	}
	/**
	 * @param attributes the attributes to set
	 */
	public void setAttributes(List<? extends KimAttributes> attributes) {
		this.attributes = attributes;
	}
	/**
	 * @return the kimType
	 */
	public KimType getKimType() {
		return this.kimType;
	}
	/**
	 * @param kimType the kimType to set
	 */
	public void setKimType(KimType kimType) {
		this.kimType = kimType;
	}

	public Map<String,Object> getAttributeEntry() {
		if(attributeEntry==null || attributeEntry.isEmpty())
			attributeEntry = KIMServiceLocatorInternal.getUiDocumentService().getAttributeEntries(getDefinitions());
		return attributeEntry;
	}

	public String getCommaDelimitedAttributesLabels(String commaDelimitedAttributesNamesList){
		String[] names = StringUtils.splitByWholeSeparator(commaDelimitedAttributesNamesList, KimConstants.KimUIConstants.COMMA_SEPARATOR);
		List<String> commaDelimitedAttributesLabels = new ArrayList<String>(names.length);
		for(String name: names){
		    Object attributeEntry = getAttributeEntry().get(name.trim());
		    if ( attributeEntry != null ) {
		        commaDelimitedAttributesLabels.add( attributeEntry.toString() );
		    }
		}
        return StringUtils.join(commaDelimitedAttributesLabels, KimConstants.KimUIConstants.COMMA_SEPARATOR);
	}

	public List<KimAttributeField> getDefinitions() {
		if (this.definitions == null || this.definitions.isEmpty()) {
            this.definitions = Collections.emptyList();
            KimTypeService kimTypeService = getKimTypeService(getKimType());
	        if(kimTypeService!=null) {
                try {
	        	  this.definitions = kimTypeService.getAttributeDefinitions(getKimType().getId());
                } catch (WebServiceException e) {
                    GlobalVariables.getMessageMap().putWarning("document.qualifier", "error.document.maintenance.group.remoteAttributesNotAvailable");
                    LOG.warn("Not able to retrieve attribute definitions via KimTypeservice from remote system for KIM Type: " + kimType.getName(), e);
                }
            }
		}
		return this.definitions;
	}

    public Map<String, KimAttributeField> getDefinitionsKeyedByAttributeName() {
        final Map<String, KimAttributeField> map = new HashMap<String, KimAttributeField>();
        for (KimAttributeField field : getDefinitions()) {
            map.put(field.getAttributeField().getName(), field);
        }
        return map;
	}


	public void setDefinitions(List<KimAttributeField> definitions) {
		this.definitions = definitions;
	}

	protected KimTypeService getKimTypeService(KimType kimType){
		if( kimTypeService==null){
	    	kimTypeService = KimFrameworkServiceLocator.getKimTypeService(kimType);
		}
		return kimTypeService;
	}

}
