/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.service.NotificationMessageDeliveryAutoRemovalService;
import org.kuali.rice.ken.service.ProcessingResult;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationMessageDeliveryAutoRemovalServiceImplTest
extends KENTestCase {
    private static final int EXPECTED_SUCCESSES = 6;

    protected void assertProcessResults() {
        Collection lockedDeliveries = this.services.getNotificationMessegDeliveryDao().getLockedDeliveries(NotificationBo.class, KRADServiceLocator.getDataObjectService());
        Assert.assertEquals((long)0L, (long)lockedDeliveries.size());
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"messageDeliveryStatus", (Object)"AUTO_REMOVED")});
        List unprocessedDeliveries = KRADServiceLocator.getDataObjectService().findMatching(NotificationMessageDelivery.class, criteria.build()).getResults();
        Assert.assertEquals((long)6L, (long)unprocessedDeliveries.size());
    }

    @Test
    public void testAutoRemovedNotificationMessageDeliveries() {
        NotificationMessageDeliveryAutoRemovalService nSvc = this.services.getNotificationMessageDeliveryAutoRemovalService();
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        ProcessingResult result = nSvc.processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        Assert.assertEquals((long)0L, (long)result.getFailures().size());
        Assert.assertEquals((long)6L, (long)result.getSuccesses().size());
        this.assertProcessResults();
    }

    @Test
    public void testAutoRemovalConcurrency() throws InterruptedException {
        final NotificationMessageDeliveryAutoRemovalService nSvc = this.services.getNotificationMessageDeliveryAutoRemovalService();
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        final ProcessingResult[] results = new ProcessingResult[2];
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                results[0] = nSvc.processAutoRemovalOfDeliveredNotificationMessageDeliveries();
            }
        });
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                results[1] = nSvc.processAutoRemovalOfDeliveredNotificationMessageDeliveries();
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        this.LOG.info((Object)("Results of thread #1: " + results[0]));
        this.LOG.info((Object)("Results of thread #2: " + results[1]));
        Assert.assertTrue((results[0].getSuccesses().size() == 6 && results[0].getFailures().size() == 0 && results[1].getSuccesses().size() == 0 && results[1].getFailures().size() == 0 || results[1].getSuccesses().size() == 6 && results[1].getFailures().size() == 0 && results[0].getSuccesses().size() == 0 && results[0].getFailures().size() == 0 ? 1 : 0) != 0);
        this.assertProcessResults();
    }
}

