/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationMessageDeliveryServiceImplTest
extends KENTestCase {
    @Test
    public void testGetNotificationMessageDelivery_validId() {
        NotificationMessageDeliveryService nSvc = this.services.getNotificationMessageDeliveryService();
        NotificationMessageDelivery nmd = nSvc.getNotificationMessageDelivery(TestConstants.VALID_MESSAGE_DELIVERY_ID);
        Assert.assertNotNull((Object)nmd.getMessageDeliveryStatus());
    }

    @Test
    public void testGetNotification_nonExistentNotification() {
        NotificationMessageDeliveryService nSvc = this.services.getNotificationMessageDeliveryService();
        NotificationMessageDelivery nmd = nSvc.getNotificationMessageDelivery(TestConstants.NON_EXISTENT_ID);
        Assert.assertNull((Object)nmd);
    }

    @Test
    public void testGetAllNotificationMessageDeliveries() {
        NotificationMessageDeliveryService nSvc = this.services.getNotificationMessageDeliveryService();
        Collection deliveries = nSvc.getNotificationMessageDeliveries();
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)5L, (long)deliveries.size());
    }

    @Test
    public void testGetSpecificNotificationMessageDeliveries() {
        NotificationBo n = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        NotificationMessageDeliveryService nSvc = this.services.getNotificationMessageDeliveryService();
        Collection deliveries = nSvc.getNotificationMessageDeliveries(n, "testuser5");
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)1L, (long)deliveries.size());
    }
}

