/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.test.util;

import java.sql.Timestamp;
import java.util.List;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.kim.api.KimConstants;

public final class MockObjectsUtil {
    private MockObjectsUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static final NotificationChannelBo buildTestNotificationChannel(String name, String description, boolean subscribable) {
        NotificationChannelBo channel = new NotificationChannelBo();
        channel.setName(name);
        channel.setDescription(description);
        channel.setSubscribable(subscribable);
        return channel;
    }

    public static final NotificationChannelBo getTestChannel1() {
        return MockObjectsUtil.buildTestNotificationChannel("Test Channel 1", "Test Channel 1 - description", true);
    }

    public static final NotificationChannelBo getTestChannel2() {
        return MockObjectsUtil.buildTestNotificationChannel("Test Channel 2", "Test Channel 2 - description", false);
    }

    public static final NotificationProducerBo buildTestNotificationProducer(String name, String description, String contactInfo) {
        NotificationProducerBo producer = new NotificationProducerBo();
        producer.setName(name);
        producer.setDescription(description);
        producer.setContactInfo(contactInfo);
        return producer;
    }

    public static final NotificationChannelReviewerBo buildTestNotificationChannelReviewer(MemberType reviewerType, String reviewerId) {
        NotificationChannelReviewerBo reviewer = new NotificationChannelReviewerBo();
        reviewer.setReviewerType(reviewerType.getCode());
        reviewer.setReviewerId(reviewerId);
        return reviewer;
    }

    public static final NotificationProducerBo getTestProducer1() {
        return MockObjectsUtil.buildTestNotificationProducer("Produer 1", "Producer 1 - description", "Producer 1 - contact info");
    }

    public static final NotificationContentTypeBo buildTestNotificationContentType(String name, String description, String namespace, String xsd, String xsl) {
        NotificationContentTypeBo contentType = new NotificationContentTypeBo();
        contentType.setName(name);
        contentType.setDescription(description);
        contentType.setNamespace(namespace);
        contentType.setXsd(xsd);
        contentType.setXsl(xsl);
        return contentType;
    }

    public static final NotificationContentTypeBo getTestContentType1() {
        return MockObjectsUtil.buildTestNotificationContentType("Content Type 1", "Content Type 1 - description", "Content Type 1 - namespace", "Simple.xsd", "Simple.xsl");
    }

    public static final NotificationPriorityBo buildTestNotificationPriority(String name, String description, Integer order) {
        NotificationPriorityBo priority = new NotificationPriorityBo();
        priority.setName(name);
        priority.setDescription(description);
        priority.setOrder(order);
        return priority;
    }

    public static final NotificationPriorityBo getTestPriority1() {
        return MockObjectsUtil.buildTestNotificationPriority("Priority 1", "Priority 1 - description", new Integer(1));
    }

    public static final NotificationRecipientBo buildTestNotificationRecipient(String recipientId, MemberType recipientType) {
        NotificationRecipientBo recipient = new NotificationRecipientBo();
        recipient.setRecipientId(recipientId);
        recipient.setRecipientType(recipientType.getCode());
        return recipient;
    }

    public static final NotificationRecipientBo getTestRecipient1() {
        return MockObjectsUtil.buildTestNotificationRecipient("ag266", KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE);
    }

    public static final NotificationRecipientBo getTestRecipient2() {
        return MockObjectsUtil.buildTestNotificationRecipient("Notification Team", KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE);
    }

    public static final NotificationBo buildTestNotification(String deliveryType, Timestamp sendDateTime, Timestamp autoRemoveDateTime, NotificationContentTypeBo contentType, String content, NotificationPriorityBo priority, NotificationProducerBo producer, NotificationChannelBo channel, List<NotificationRecipientBo> recipients, List<NotificationSenderBo> senders) {
        NotificationBo notification = new NotificationBo();
        notification.setCreationDateTimeValue(new Timestamp(System.currentTimeMillis()));
        notification.setDeliveryType(deliveryType);
        notification.setSendDateTimeValue(sendDateTime);
        notification.setAutoRemoveDateTimeValue(autoRemoveDateTime);
        notification.setContentType(contentType);
        notification.setContent(content);
        notification.setPriority(priority);
        notification.setProducer(producer);
        notification.setChannel(channel);
        notification.setRecipients(recipients);
        notification.setSenders(senders);
        return notification;
    }

    public static final NotificationSenderBo buildTestNotificationSender(String userId) {
        NotificationSenderBo sender = new NotificationSenderBo();
        sender.setSenderName(userId);
        return sender;
    }

    public static final NotificationSenderBo getTestSender1() {
        return MockObjectsUtil.buildTestNotificationSender("Joe Schmoe");
    }

    public static final NotificationSenderBo getTestSender2() {
        return MockObjectsUtil.buildTestNotificationSender("John Doe");
    }
}

