/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationMessageContentServiceImplTest
extends KENTestCase {
    private static final String SAMPLE_EVENT_MESSAGE = "sample_message_event_type.xml";
    private static final String SAMPLE_SIMPLE_MESSAGE = "sample_message_simple_type.xml";
    private static final String SAMPLE_MALFORMED_EVENT_MESSAGE = "sample_malformed_message_event_type.xml";
    private static final String SAMPLE_MALFORMED_SIMPLE_MESSAGE = "sample_malformed_message_simple_type.xml";
    private static final String SAMPLE_BADNAMESPACE_EVENT_MESSAGE = "badnamespace_message_event_type.xml";
    private static final String SAMPLE_CHANNEL = "Test Channel #1";
    private static final String VALID_CHANNEL = "Test Channel #2";
    private static final String VALID_TYPE = "FYI";
    private static final String VALID_CONTENT = "<content xmlns=\"ns:notification/ContentTypeSimple\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:notification/ContentTypeSimple resource:notification/ContentTypeSimple\">\n    <message>Holiday-Ho-Out Starts Next Week - 11/20/2006!</message>\n</content>";
    private static final String sampleEdlFile = "NotificationDocumentContent.xml";

    private void testParseNotificationRequestMessage(String samplePath) throws Exception {
        NotificationMessageContentService impl = this.services.getNotificationMessageContentService();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(samplePath);
        System.out.println(is);
        NotificationBo notification = impl.parseNotificationRequestMessage(is);
        Assert.assertEquals((Object)SAMPLE_CHANNEL, (Object)notification.getChannel().getName());
        System.out.println(notification.getSenders());
        System.out.println("notification id: " + notification.getId());
        List sl = notification.getSenders();
        Assert.assertTrue((sl.size() > 0 ? 1 : 0) != 0);
        for (NotificationSenderBo s : sl) {
            Assert.assertNotNull((Object)s);
            Assert.assertNotNull((Object)s.getSenderName());
        }
        List rl = notification.getRecipients();
        Assert.assertTrue((rl.size() > 0 ? 1 : 0) != 0);
        for (NotificationRecipientBo r : rl) {
            Assert.assertNotNull((Object)r);
            Assert.assertNotNull((Object)r.getRecipientId());
        }
        notification.setCreationDateTimeValue(new Timestamp(System.currentTimeMillis()));
        KRADServiceLocator.getDataObjectService().save((Object)notification, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test
    public void testParseEventNotificationRequestMessage() throws Exception {
        this.testParseNotificationRequestMessage(SAMPLE_EVENT_MESSAGE);
    }

    @Test
    public void testParseSimpleNotificationRequestMessage() throws Exception {
        this.testParseNotificationRequestMessage(SAMPLE_SIMPLE_MESSAGE);
    }

    @Test
    public void testParseMalformedEventNotificationRequestMessage() throws Exception {
        try {
            this.testParseNotificationRequestMessage(SAMPLE_MALFORMED_EVENT_MESSAGE);
            Assert.fail((String)"malformed event message passed validation");
        }
        catch (XmlException ixe) {
            return;
        }
    }

    @Test
    public void testParseBadNamespaceEventNotificationRequestMessage() throws Exception {
        try {
            this.testParseNotificationRequestMessage(SAMPLE_BADNAMESPACE_EVENT_MESSAGE);
            Assert.fail((String)"malformed event message passed validation");
        }
        catch (XmlException ixe) {
            return;
        }
    }

    @Test
    public void testParseMalformedSimpleNotificationRequestMessage() throws Exception {
        try {
            this.testParseNotificationRequestMessage(SAMPLE_MALFORMED_SIMPLE_MESSAGE);
            Assert.fail((String)"malformed simple message passed validation");
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
    }

    @Test
    public void testGenerateNotificationResponseMessage() throws Exception {
        NotificationResponseBo response = new NotificationResponseBo();
        response.setStatus("PASS");
        response.setMessage("Here is your response");
        NotificationMessageContentService impl = this.services.getNotificationMessageContentService();
        String xml = impl.generateNotificationResponseMessage(response);
        Assert.assertTrue((xml.length() == 89 ? 1 : 0) != 0);
    }

    @Test
    public void testGenerateNotificationMessage() throws Exception {
        NotificationMessageContentService impl = this.services.getNotificationMessageContentService();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(SAMPLE_SIMPLE_MESSAGE);
        System.out.println(is);
        NotificationBo notification = impl.parseNotificationRequestMessage(is);
        String XML = impl.generateNotificationMessage(notification);
        Assert.assertTrue((XML.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testParseSerializedNotificationXml() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(sampleEdlFile);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        NotificationMessageContentService impl = this.services.getNotificationMessageContentService();
        NotificationBo notification = impl.parseSerializedNotificationXml(bytes);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((Object)VALID_CHANNEL, (Object)notification.getChannel().getName());
        Assert.assertEquals((Object)VALID_TYPE, (Object)notification.getDeliveryType());
        Assert.assertEquals((Object)VALID_CONTENT.replaceAll("\\s+", " "), (Object)notification.getContent().replaceAll("\\s+", " "));
    }
}

