/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationWorkflowDocumentServiceImplTest
extends KENTestCase {
    private static final String CUSTOM_NOTIFICATION_DOC_TYPE = "CustomNotification";

    @Test
    public void createAndAdHocRouteNotificationWorkflowDocument_defaultKEW() throws WorkflowException {
        NotificationBo notification = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        notification.setDocTypeName("KualiNotification");
        Document document = this.createNotificationWorkflowDocument(notification);
        Assert.assertEquals((Object)"KualiNotification", (Object)document.getDocumentTypeName());
    }

    @Test
    public void createAndAdHocRouteNotificationWorkflowDocument_undefinedKEW() throws WorkflowException {
        NotificationBo notification = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        Document document = this.createNotificationWorkflowDocument(notification);
        Assert.assertEquals((Object)"KualiNotification", (Object)document.getDocumentTypeName());
    }

    @Test
    public void createAndAdHocRouteNotificationWorkflowDocument_customKEW() throws WorkflowException {
        NotificationBo notification = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        notification.setDocTypeName(CUSTOM_NOTIFICATION_DOC_TYPE);
        Document document = this.createNotificationWorkflowDocument(notification);
        Assert.assertEquals((Object)CUSTOM_NOTIFICATION_DOC_TYPE, (Object)document.getDocumentTypeName());
    }

    protected Document createNotificationWorkflowDocument(NotificationBo notification) {
        NotificationMessageDelivery messageDelivery = new NotificationMessageDelivery();
        messageDelivery.setId(Long.valueOf(0L));
        messageDelivery.setMessageDeliveryStatus("UNDELIVERED");
        messageDelivery.setNotification(notification);
        messageDelivery.setUserRecipientId("testuser5");
        String documentId = this.services.getNotificationWorkflowDocumentService().createAndAdHocRouteNotificationWorkflowDocument(messageDelivery, Util.getNotificationSystemUser(), messageDelivery.getUserRecipientId(), "The notification message has been delivered by the Notification System.");
        Document document = KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
        return document;
    }
}

