/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.core.impl.services.CoreImplServiceLocator;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.kuali.rice.test.lifecycles.KEWXmlDataLoaderLifecycle;
import org.kuali.rice.test.runners.LoadTimeWeavableTestRunner;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
@RunWith(value=LoadTimeWeavableTestRunner.class)
@org.kuali.rice.test.runners.BootstrapTest(value=BootstrapTest.class)
public abstract class KIMTestCase
extends BaselineTestCase {
    private static final String KIM_MODULE_NAME = "kim";

    public KIMTestCase() {
        super(KIM_MODULE_NAME);
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        List suiteLifecycles = super.getSuiteLifecycles();
        suiteLifecycles.add(new KEWXmlDataLoaderLifecycle("classpath:org/kuali/rice/kim/test/DefaultSuiteTestData.xml"));
        return suiteLifecycles;
    }

    protected void loadSuiteTestData() throws Exception {
        super.loadSuiteTestData();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/DefaultSuiteTestData.sql", "/").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/CircularRolesTestData.sql", "/").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/CircularGroupsTestData.sql", "/").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/DefaultSuiteLDAPTestData.sql", "/").runSql();
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(new QName("KIMTestHarnessApplicationResourceLoader"), "classpath:KIMTestHarnessSpringBeans.xml", null);
        springResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        return springResourceLoader;
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        List lifecycles = super.getPerTestLifecycles();
        lifecycles.add(new ClearCacheLifecycle());
        return lifecycles;
    }

    protected List<String> getPerTestTablesNotToClear() {
        ArrayList<String> tablesNotToClear = new ArrayList<String>();
        tablesNotToClear.add("KRIM_.*");
        tablesNotToClear.add("KRNS_.*");
        tablesNotToClear.add("KRCR_.*");
        tablesNotToClear.add("KREW_.*");
        return tablesNotToClear;
    }

    protected String getModuleName() {
        return KIM_MODULE_NAME;
    }

    protected String getNextSequenceStringValue(String sequenceName) {
        return MaxValueIncrementerFactory.getIncrementer((DataSource)TestHarnessServiceLocator.getDataSource(), (String)sequenceName).nextStringValue();
    }

    public void clearNamedCache(String cacheName) {
        try {
            CacheManager cm = CoreImplServiceLocator.getCacheManagerRegistry().getCacheManagerByCacheName(cacheName);
            if (cm != null) {
                Cache cache = cm.getCache(cacheName);
                if (cache != null) {
                    cache.clear();
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("Cleared " + cacheName + " cache.");
                    }
                } else {
                    this.LOG.debug("Unable to find cache for " + cacheName + ".");
                }
            } else {
                this.LOG.info("Unable to find cache manager when attempting to clear " + cacheName);
            }
        }
        catch (RiceIllegalArgumentException e) {
            this.LOG.info("Cache manager not found when attempting to clear " + cacheName);
        }
    }

    public static final class BootstrapTest
    extends KIMTestCase {
        @Test
        public void bootstrapTest() {
        }
    }

    public class ClearCacheLifecycle
    extends BaseLifecycle {
        public void stop() throws Exception {
            super.stop();
        }
    }
}

