/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeAttributeContract;
import org.kuali.rice.kim.api.type.KimTypeContract;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class GroupUpdateServiceApiCustomTest
extends KIMTestCase {
    private static final String NAMESPACE = "KUALI";
    private static final String KIM_ATTRIBUTE_ID = "KS-KRIM-ATTR-DEFN-1003";
    private static final String KIM_ATTRIBUTE_LABEL = "Hold Authorization Org Id";
    private static final String KIM_ATTRIBUTE_NAME = "org.kuali.student.hold.authorization.orgId";
    private static final String KIM_ATTRIBUTE_VALUE = "ORGID-128487550";
    private static final String KIM_ATTRIBUTE_COMPONENT_NAME = "org.kuali.rice.student.bo.KualiStudentKimAttributes";
    private static final String KIM_TYPE_ID = "KS-KRIM-TYP-1011";
    private static final String KIM_TYPE_NAME = "KS Hold Org Authorization Group Type";
    private static final String KIM_TYPE_SERVICE_NAME = "kimGroupTypeService";
    private static final String KIM_TYPE_ATTRIBUTE_ID = "KS-KRIM-TYP-ATTR-1027";
    private static final String GROUP_NAME = "gAwAttrs";

    @Test
    public void testCreateGroupWithCustomKimTypeAttributes() {
        KimAttribute.Builder kimAttribute = KimAttribute.Builder.create((String)KIM_ATTRIBUTE_COMPONENT_NAME, (String)KIM_ATTRIBUTE_NAME, (String)NAMESPACE);
        kimAttribute.setAttributeLabel(KIM_ATTRIBUTE_LABEL);
        kimAttribute.setId(KIM_ATTRIBUTE_ID);
        kimAttribute.setActive(true);
        KimAttributeBo kimAddrBo = (KimAttributeBo)KRADServiceLocator.getDataObjectService().save((Object)KimAttributeBo.from((KimAttribute)kimAttribute.build()), new PersistenceOption[0]);
        KimType.Builder kimTypeBuilder = KimType.Builder.create();
        kimTypeBuilder.setId(KIM_TYPE_ID);
        kimTypeBuilder.setName(KIM_TYPE_NAME);
        kimTypeBuilder.setNamespaceCode(NAMESPACE);
        kimTypeBuilder.setServiceName(KIM_TYPE_SERVICE_NAME);
        kimTypeBuilder.setActive(true);
        KimTypeBo kimTypeBo = (KimTypeBo)KRADServiceLocator.getDataObjectService().save((Object)KimTypeBo.from((KimType)kimTypeBuilder.build()), new PersistenceOption[0]);
        KimTypeAttribute.Builder kimTypeAttributeBuilder = KimTypeAttribute.Builder.create();
        kimTypeAttributeBuilder.setId(KIM_TYPE_ATTRIBUTE_ID);
        kimTypeAttributeBuilder.setActive(true);
        kimTypeAttributeBuilder.setSortCode("a");
        kimTypeAttributeBuilder.setKimTypeId(KIM_TYPE_ID);
        kimTypeAttributeBuilder.setKimAttribute(kimAttribute);
        KimTypeAttributeBo kimTypeAttrBo = (KimTypeAttributeBo)KRADServiceLocator.getDataObjectService().save((Object)KimTypeAttributeBo.from((KimTypeAttribute)kimTypeAttributeBuilder.build()), new PersistenceOption[0]);
        kimTypeBuilder = KimType.Builder.create((KimTypeContract)KimApiServiceLocator.getKimTypeInfoService().getKimType(KIM_TYPE_ID));
        kimTypeAttributeBuilder = KimTypeAttribute.Builder.create((KimTypeAttributeContract)kimTypeAttrBo);
        List<KimTypeAttribute.Builder> attrList = Collections.singletonList(kimTypeAttributeBuilder);
        kimTypeBuilder.setAttributeDefinitions(attrList);
        kimTypeBo = (KimTypeBo)KRADServiceLocator.getDataObjectService().save((Object)KimTypeBo.from((KimType)kimTypeBuilder.build()), new PersistenceOption[0]);
        KRADServiceLocator.getDataObjectService().flush(KimTypeBo.class);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(KIM_ATTRIBUTE_NAME, KIM_ATTRIBUTE_VALUE);
        Group.Builder groupInfo = Group.Builder.create((String)NAMESPACE, (String)GROUP_NAME, (String)KIM_TYPE_ID);
        groupInfo.setAttributes(attributes);
        groupInfo.setActive(true);
        groupInfo.setDescription("Hold Authorization Org Id ORGID-128487550");
        Group group = KimApiServiceLocator.getGroupService().createGroup(groupInfo.build());
        Group result = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(NAMESPACE, GROUP_NAME);
        Assert.assertEquals((Object)groupInfo.isActive(), (Object)result.isActive());
        Assert.assertTrue((boolean)groupInfo.getNamespaceCode().equals(result.getNamespaceCode()));
        Assert.assertTrue((boolean)groupInfo.getName().equals(result.getName()));
        Assert.assertTrue((boolean)groupInfo.getKimTypeId().equals(result.getKimTypeId()));
        Assert.assertEquals((long)1L, (long)result.getAttributes().size());
        Assert.assertTrue((boolean)((String)result.getAttributes().get(KIM_ATTRIBUTE_NAME)).contains(KIM_ATTRIBUTE_VALUE));
    }
}

