/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeBoService;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.type.ValidationActionType;
import org.kuali.rice.krms.framework.type.ValidationRuleType;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.ActionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaBoServiceImpl;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextAttributeBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.RuleAttributeBo;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.repository.RuleBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;
import org.kuali.rice.krms.test.AbstractBoTest;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.annotation.Transactional;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class ValidationIntegrationTest
extends AbstractBoTest {
    private static final String EVENT_ATTRIBUTE = "Event";
    private static final String TERM_NAME = "campusCodeTermSpec";
    private static final String CONTEXT_NAME = "ValidationITContext";
    private static final String WARNING_MESSAGE = "Warning Message.";
    private static final String ERROR_MESSAGE = "Error Message.";
    private static final String VALIDATION_ACTION_TYPE_SERVICE = "validationActionTypeService";
    private static final String VALIDATION_RULE_TYPE_SERVICE = "validationRuleTypeService";
    private KrmsTypeBoService krmsTypeBoService;
    private KrmsAttributeDefinitionService krmsAttributeDefinitionService;
    private PropositionBoService propositionBoService;
    private TermBoService termBoService;
    private ContextBoService contextRepository;
    private AgendaBoService agendaBoService;
    private RuleBoService ruleBoService;
    private ActionBoService actionBoService;

    @Before
    public void setup() {
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.krmsTypeBoService = new KrmsTypeBoServiceImpl();
        ((KrmsTypeBoServiceImpl)this.krmsTypeBoService).setDataObjectService(this.getDataObjectService());
        this.propositionBoService = new PropositionBoServiceImpl();
        ((PropositionBoServiceImpl)this.propositionBoService).setDataObjectService(this.getDataObjectService());
        this.termBoService = new TermBoServiceImpl();
        ((TermBoServiceImpl)this.termBoService).setDataObjectService((DataObjectService)GlobalResourceLoader.getService((String)"dataObjectService"));
        this.contextRepository = new ContextBoServiceImpl();
        ((ContextBoServiceImpl)this.contextRepository).setDataObjectService(this.getDataObjectService());
        this.agendaBoService = new AgendaBoServiceImpl();
        ((AgendaBoServiceImpl)this.agendaBoService).setDataObjectService(this.getDataObjectService());
        ((AgendaBoServiceImpl)this.agendaBoService).setAttributeDefinitionService(this.krmsAttributeDefinitionService);
        this.ruleBoService = new RuleBoServiceImpl();
        ((RuleBoServiceImpl)this.ruleBoService).setDataObjectService(this.getDataObjectService());
        this.actionBoService = new ActionBoServiceImpl();
        ((ActionBoServiceImpl)this.actionBoService).setDataObjectService(this.getDataObjectService());
    }

    @Transactional
    @Test
    public void testValidWarning() {
        KrmsAttributeTypeDefinitionAndBuilders ruleDefs = this.createKrmsAttributeTypeDefinitionAndBuilders("ruleTypeCode", "KR-RULE", ValidationRuleType.VALID.toString(), true, ValidationRuleType.VALID.toString(), ValidationRuleType.VALID.getCode(), VALIDATION_RULE_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionTypeCode", "KR-RULE", ValidationActionType.WARNING.toString(), true, ValidationActionType.WARNING.toString(), ValidationActionType.WARNING.getCode(), VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionMessageDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionMessage", "KR-RULE", "Valdiation Action Message", true, "Valdiation Action Message", WARNING_MESSAGE, VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        LinkedList<KrmsAttributeTypeDefinitionAndBuilders> actionDefs = new LinkedList<KrmsAttributeTypeDefinitionAndBuilders>();
        actionDefs.add(actionDef);
        actionDefs.add(actionMessageDef);
        ContextBo contextBo = this.createContext();
        RuleBo ruleBo = this.createRuleWithAction(ruleDefs, actionDefs, contextBo, WARNING_MESSAGE);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute();
        Assert.assertTrue((results.getAttribute("validations") == null ? 1 : 0) != 0);
    }

    @Transactional
    @Test
    public void testInvalidWarning() {
        KrmsAttributeTypeDefinitionAndBuilders ruleDefs = this.createKrmsAttributeTypeDefinitionAndBuilders("ruleTypeCode", "KR-RULE", ValidationRuleType.INVALID.toString(), true, ValidationRuleType.INVALID.toString(), ValidationRuleType.INVALID.getCode(), VALIDATION_RULE_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionTypeCode", "KR-RULE", ValidationActionType.WARNING.toString(), true, ValidationActionType.WARNING.toString(), ValidationActionType.WARNING.getCode(), VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionMessageDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionMessage", "KR-RULE", "Valdiation Action Message", true, "Valdiation Action Message", WARNING_MESSAGE, VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        LinkedList<KrmsAttributeTypeDefinitionAndBuilders> actionDefs = new LinkedList<KrmsAttributeTypeDefinitionAndBuilders>();
        actionDefs.add(actionDef);
        actionDefs.add(actionMessageDef);
        ContextBo contextBo = this.createContext();
        RuleBo ruleBo = this.createRuleWithAction(ruleDefs, actionDefs, contextBo, WARNING_MESSAGE);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute();
        Assert.assertNotNull((Object)results.getAttribute("validations"));
        Assert.assertEquals((Object)(ValidationActionType.WARNING.getCode() + ":" + WARNING_MESSAGE), (Object)results.getAttribute("validations"));
    }

    @Transactional
    @Test
    public void testValidError() {
        KrmsAttributeTypeDefinitionAndBuilders ruleDefs = this.createKrmsAttributeTypeDefinitionAndBuilders("ruleTypeCode", "KR-RULE", ValidationRuleType.VALID.toString(), true, ValidationRuleType.VALID.toString(), ValidationRuleType.VALID.getCode(), VALIDATION_RULE_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionTypeCode", "KR-RULE", ValidationActionType.ERROR.toString(), true, ValidationActionType.ERROR.toString(), ValidationActionType.ERROR.getCode(), VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionMessageDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionMessage", "KR-RULE", "Valdiation Action Message", true, "Valdiation Action Message", ERROR_MESSAGE, VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        LinkedList<KrmsAttributeTypeDefinitionAndBuilders> actionDefs = new LinkedList<KrmsAttributeTypeDefinitionAndBuilders>();
        actionDefs.add(actionDef);
        actionDefs.add(actionMessageDef);
        ContextBo contextBo = this.createContext();
        RuleBo ruleBo = this.createRuleWithAction(ruleDefs, actionDefs, contextBo, ERROR_MESSAGE);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute();
        Assert.assertTrue((results.getAttribute("validations") == null ? 1 : 0) != 0);
    }

    @Transactional
    @Test
    public void testInvalidError() {
        KrmsAttributeTypeDefinitionAndBuilders ruleDefs = this.createKrmsAttributeTypeDefinitionAndBuilders("ruleTypeCode", "KR-RULE", ValidationRuleType.INVALID.toString(), true, ValidationRuleType.INVALID.toString(), ValidationRuleType.INVALID.getCode(), VALIDATION_RULE_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionTypeCode", "KR-RULE", ValidationActionType.ERROR.toString(), true, ValidationActionType.ERROR.toString(), ValidationActionType.ERROR.getCode(), VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        KrmsAttributeTypeDefinitionAndBuilders actionMessageDef = this.createKrmsAttributeTypeDefinitionAndBuilders("actionMessage", "KR-RULE", "Valdiation Action Message", true, "Valdiation Action Message", ERROR_MESSAGE, VALIDATION_ACTION_TYPE_SERVICE, this.krmsTypeBoService, 1);
        LinkedList<KrmsAttributeTypeDefinitionAndBuilders> actionDefs = new LinkedList<KrmsAttributeTypeDefinitionAndBuilders>();
        actionDefs.add(actionDef);
        actionDefs.add(actionMessageDef);
        ContextBo contextBo = this.createContext();
        RuleBo ruleBo = this.createRuleWithAction(ruleDefs, actionDefs, contextBo, ERROR_MESSAGE);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute();
        Assert.assertNotNull((Object)results.getAttribute("validations"));
        Assert.assertEquals((Object)(ValidationActionType.ERROR.getCode() + ":" + ERROR_MESSAGE), (Object)results.getAttribute("validations"));
    }

    @Transactional
    @Test
    public void testDef() {
        ContextDefinition contextDefinition = this.createContextDefinition("KR-RULE");
        this.createAgendaDefinition(contextDefinition, "ValidationIntegration", "KR-RULE");
        this.engineExecute();
    }

    private ContextDefinition createContextDefinition(String nameSpace) {
        KrmsAttributeDefinition.Builder contextTypeAttributeDefnBuilder = KrmsAttributeDefinition.Builder.create(null, (String)"Context1Qualifier", (String)nameSpace);
        contextTypeAttributeDefnBuilder.setLabel("Context 1 Qualifier");
        KrmsAttributeDefinition contextTypeAttributeDefinition = this.krmsAttributeDefinitionService.createAttributeDefinition(contextTypeAttributeDefnBuilder.build());
        KrmsTypeAttribute.Builder krmsTypeAttrBuilder = KrmsTypeAttribute.Builder.create(null, (String)contextTypeAttributeDefinition.getId(), (Integer)1);
        KrmsTypeDefinition.Builder krmsContextTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"KrmsTestContextType", (String)nameSpace);
        krmsContextTypeDefnBuilder.setAttributes(Collections.singletonList(krmsTypeAttrBuilder));
        KrmsTypeDefinition krmsContextTypeDefinition = krmsContextTypeDefnBuilder.build();
        krmsContextTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsContextTypeDefinition);
        ContextDefinition.Builder contextBuilder = ContextDefinition.Builder.create((String)nameSpace, (String)CONTEXT_NAME);
        contextBuilder.setTypeId(krmsContextTypeDefinition.getId());
        ContextDefinition contextDefinition = contextBuilder.build();
        contextDefinition = this.contextRepository.createContext(contextDefinition);
        ContextAttributeBo contextAttribute = new ContextAttributeBo();
        contextAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)contextTypeAttributeDefinition));
        contextAttribute.setContext(ContextBo.from((ContextDefinition)contextDefinition));
        contextAttribute.setValue("BLAH");
        this.getDataObjectService().save((Object)contextAttribute, new PersistenceOption[]{PersistenceOption.FLUSH});
        return contextDefinition;
    }

    private void createAgendaDefinition(ContextDefinition contextDefinition, String eventName, String nameSpace) {
        AgendaDefinition agendaDef = AgendaDefinition.Builder.create(null, (String)"testAgenda", null, (String)contextDefinition.getId()).build();
        agendaDef = this.agendaBoService.createAgenda(agendaDef);
        AgendaItemDefinition.Builder agendaItemBuilder1 = AgendaItemDefinition.Builder.create(null, (String)agendaDef.getId());
        RuleDefinition ruleDefinition = this.createRuleDefinition1(contextDefinition, nameSpace);
        agendaItemBuilder1.setRuleId(ruleDefinition.getId());
        AgendaItemDefinition agendaItem1 = this.agendaBoService.createAgendaItem(agendaItemBuilder1.build());
        AgendaDefinition.Builder agendaDefBuilder1 = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDef);
        agendaDefBuilder1.setFirstItemId(agendaItem1.getId());
        agendaDef = agendaDefBuilder1.build();
        this.agendaBoService.updateAgenda(agendaDef);
    }

    private RuleDefinition createRuleDefinition1(ContextDefinition contextDefinition, String nameSpace) {
        RuleDefinition.Builder ruleDefBuilder1 = RuleDefinition.Builder.create(null, (String)"Rule1", (String)nameSpace, null, null);
        RuleDefinition ruleDef1 = this.ruleBoService.createRule(ruleDefBuilder1.build());
        ruleDefBuilder1 = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDef1);
        ruleDefBuilder1.setProposition(this.createCompoundProposition(contextDefinition, ruleDef1));
        ruleDef1 = ruleDefBuilder1.build();
        ruleDef1 = this.ruleBoService.updateRule(ruleDef1);
        ActionDefinition.Builder actionDefBuilder1 = ActionDefinition.Builder.create(null, (String)"testAction1", (String)nameSpace, (String)this.createKrmsActionTypeDefinition(nameSpace).getId(), (String)ruleDef1.getId(), (Integer)1);
        ActionDefinition actionDef1 = this.actionBoService.createAction(actionDefBuilder1.build());
        return ruleDef1;
    }

    private KrmsTypeDefinition createKrmsCampusTypeDefinition(String nameSpace) {
        KrmsTypeDefinition.Builder krmsCampusTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"CAMPUS", (String)nameSpace);
        KrmsTypeDefinition krmsCampusTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsCampusTypeDefnBuilder.build());
        return krmsCampusTypeDefinition;
    }

    private KrmsTypeDefinition createKrmsActionTypeDefinition(String nameSpace) {
        KrmsTypeDefinition.Builder krmsActionTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"KrmsActionResolverType", (String)nameSpace);
        krmsActionTypeDefnBuilder.setServiceName("testActionTypeService");
        KrmsTypeDefinition krmsActionTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsActionTypeDefnBuilder.build());
        return krmsActionTypeDefinition;
    }

    private EngineResults engineExecute() {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("name", CONTEXT_NAME);
        contextQualifiers.put("namespaceCode", "KR-RULE");
        SelectionCriteria sc1 = SelectionCriteria.createCriteria((DateTime)new DateTime(), contextQualifiers, Collections.emptyMap());
        Facts.Builder factsBuilder1 = Facts.Builder.create();
        factsBuilder1.addFact(TERM_NAME, (Object)"BL");
        ExecutionOptions xOptions1 = new ExecutionOptions();
        xOptions1.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        EngineResults engineResults = KrmsApiServiceLocator.getEngine().execute(sc1, factsBuilder1.build(), xOptions1);
        Assert.assertNotNull((Object)engineResults);
        Assert.assertTrue((engineResults.getAllResults().size() > 0 ? 1 : 0) != 0);
        this.print(engineResults);
        return engineResults;
    }

    private void print(EngineResults engineResults) {
        System.out.println(ToStringBuilder.reflectionToString((Object)engineResults, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
    }

    private ContextBo createContext() {
        KrmsAttributeTypeDefinitionAndBuilders defs = this.createKrmsAttributeTypeDefinitionAndBuilders("ContextAttributeName", "KR-RULE", "ContextLabel", true, "ContextTypeName", "ContextTypeId", "ContextServiceName", this.krmsTypeBoService, 1);
        ContextBo contextBo = new ContextBo();
        contextBo.setNamespace("KR-RULE");
        contextBo.setName(CONTEXT_NAME);
        contextBo.setTypeId(defs.typeDef.getId());
        return (ContextBo)this.getDataObjectService().save((Object)contextBo, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private KrmsAttributeTypeDefinitionAndBuilders createKrmsAttributeTypeDefinitionAndBuilders(String attributeName, String namespace, String label, boolean active, String typeName, String typeId, String serviceName, KrmsTypeBoService krmsTypeBoService, Integer sequenceNumber) {
        KrmsAttributeDefinitionBo attributeDefinitionBo = new KrmsAttributeDefinitionBo();
        attributeDefinitionBo.setNamespace(namespace);
        attributeDefinitionBo.setName(attributeName);
        attributeDefinitionBo.setLabel(label);
        attributeDefinitionBo.setActive(active);
        attributeDefinitionBo = (KrmsAttributeDefinitionBo)this.getDataObjectService().save((Object)attributeDefinitionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)attributeDefinitionBo.getId());
        KrmsAttributeDefinition attribDef = KrmsAttributeDefinitionBo.to((KrmsAttributeDefinitionBo)attributeDefinitionBo);
        KrmsTypeDefinition.Builder typeDefinition = KrmsTypeDefinition.Builder.create((String)typeName, (String)namespace);
        typeDefinition.setServiceName(serviceName);
        KrmsTypeAttribute.Builder attribDefinitionBuilder = KrmsTypeAttribute.Builder.create((String)typeId, (String)attribDef.getId(), (Integer)sequenceNumber);
        typeDefinition.getAttributes().add(attribDefinitionBuilder);
        KrmsTypeDefinition typeDef = krmsTypeBoService.createKrmsType(typeDefinition.build());
        Assert.assertNotNull((Object)typeDef);
        return new KrmsAttributeTypeDefinitionAndBuilders(attribDef, attribDefinitionBuilder, typeDef, typeDefinition);
    }

    private RuleBo createRuleWithAction(KrmsAttributeTypeDefinitionAndBuilders ruleBits, List<KrmsAttributeTypeDefinitionAndBuilders> actionBits, ContextBo contextBo, String message) {
        RuleBo rule = new RuleBo();
        rule.setTypeId(ruleBits.typeDef.getId());
        rule.setNamespace(ruleBits.typeDef.getNamespace());
        rule.setName(ruleBits.typeDef.getName());
        ActionBo action = new ActionBo();
        action.setTypeId(actionBits.get((int)0).typeDef.getId());
        action.setDescription("Description of validation action for message " + actionBits.get((int)0).attribDef.getDescription());
        action.setNamespace(actionBits.get((int)0).typeDef.getNamespace());
        action.setName(actionBits.get((int)0).typeDef.getName());
        action.setSequenceNumber(actionBits.get((int)0).typeAttribBuilder.getSequenceNumber());
        ArrayList<ActionAttributeBo> actionAttributes = new ArrayList<ActionAttributeBo>();
        action.setAttributeBos(actionAttributes);
        for (KrmsAttributeTypeDefinitionAndBuilders actionBit : actionBits) {
            ActionAttributeBo actionAttribute = new ActionAttributeBo();
            actionAttributes.add(actionAttribute);
            actionAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)actionBit.attribDef));
            actionAttribute.setValue(actionBit.typeAttribBuilder.getTypeId());
            actionAttribute.setAction(action);
        }
        rule.getActions().add(action);
        action.setRule(rule);
        rule = (RuleBo)this.getDataObjectService().save((Object)rule, new PersistenceOption[]{PersistenceOption.FLUSH});
        RuleAttributeBo ruleType = new RuleAttributeBo();
        ruleType.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)ruleBits.attribDef));
        ruleType.setValue(ruleBits.typeAttribBuilder.getTypeId());
        ruleType.setRule(rule);
        rule.getAttributeBos().add(ruleType);
        rule = (RuleBo)this.getDataObjectService().save((Object)rule, new PersistenceOption[]{PersistenceOption.FLUSH});
        RuleDefinition ruleDef = RuleBo.to((RuleBo)rule);
        PropositionDefinition propDef = this.createPropositionDefinition1(ContextBo.to((ContextBo)contextBo), ruleDef).build();
        propDef = this.propositionBoService.createProposition(propDef);
        rule.setProposition(PropositionBo.from((PropositionDefinition)propDef));
        rule = (RuleBo)this.getDataObjectService().save((Object)rule, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)rule.getId());
        Assert.assertNotNull((Object)propDef.getId());
        Assert.assertEquals((Object)propDef.getRuleId(), (Object)rule.getId());
        Assert.assertEquals((long)1L, (long)rule.getActions().size());
        Assert.assertNotNull((Object)((ActionBo)rule.getActions().get(0)).getId());
        Assert.assertEquals((long)2L, (long)((ActionBo)rule.getActions().get(0)).getAttributeBos().size());
        return rule;
    }

    private void createActionAttributeBo(String namespace, String attributeName, String label, boolean active, String actionAttribDefId, String value, Set<ActionAttributeBo> actionAttributes) {
        KrmsAttributeDefinitionBo attributeDefinitionBo = new KrmsAttributeDefinitionBo();
        attributeDefinitionBo.setNamespace(namespace);
        attributeDefinitionBo.setName(attributeName);
        attributeDefinitionBo.setLabel(label);
        attributeDefinitionBo.setActive(active);
        attributeDefinitionBo = (KrmsAttributeDefinitionBo)this.getDataObjectService().save((Object)attributeDefinitionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)attributeDefinitionBo.getId());
        KrmsAttributeDefinition attribDef = KrmsAttributeDefinitionBo.to((KrmsAttributeDefinitionBo)attributeDefinitionBo);
        ActionAttributeBo actionAttribute = new ActionAttributeBo();
        actionAttributes.add(actionAttribute);
        actionAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)attribDef));
        actionAttribute.setValue(value);
    }

    private PropositionDefinition.Builder createPropositionDefinition1(ContextDefinition contextDefinition, RuleDefinition ruleDef1) {
        PropositionDefinition.Builder propositionDefBuilder1 = PropositionDefinition.Builder.create(null, (String)PropositionType.SIMPLE.getCode(), (String)ruleDef1.getId(), null, Collections.emptyList());
        propositionDefBuilder1.setDescription("is campus bloomington");
        ArrayList<PropositionParameter.Builder> propositionParams1 = new ArrayList<PropositionParameter.Builder>();
        propositionParams1.add(PropositionParameter.Builder.create(null, null, (String)this.createTermDefinition1(contextDefinition).getId(), (String)PropositionParameterType.TERM.getCode(), (Integer)1));
        propositionParams1.add(PropositionParameter.Builder.create(null, null, (String)"BL", (String)PropositionParameterType.CONSTANT.getCode(), (Integer)2));
        propositionParams1.add(PropositionParameter.Builder.create(null, null, (String)"=", (String)PropositionParameterType.OPERATOR.getCode(), (Integer)3));
        for (PropositionParameter.Builder propositionParamBuilder : propositionParams1) {
            propositionParamBuilder.setProposition(propositionDefBuilder1);
        }
        propositionDefBuilder1.setParameters(propositionParams1);
        return propositionDefBuilder1;
    }

    private PropositionDefinition.Builder createCompoundProposition(ContextDefinition contextDefinition, RuleDefinition ruleDef1) {
        ArrayList<PropositionParameter.Builder> propositionParameterBuilderList = new ArrayList<PropositionParameter.Builder>();
        propositionParameterBuilderList.add(PropositionParameter.Builder.create(null, null, (String)this.createTermDefinition1(contextDefinition).getId(), (String)PropositionParameterType.TERM.getCode(), (Integer)1));
        propositionParameterBuilderList.add(PropositionParameter.Builder.create(null, null, (String)"BL", (String)PropositionParameterType.CONSTANT.getCode(), (Integer)2));
        propositionParameterBuilderList.add(PropositionParameter.Builder.create(null, null, (String)ComparisonOperator.EQUALS.getCode(), (String)PropositionParameterType.OPERATOR.getCode(), (Integer)3));
        PropositionDefinition.Builder propositionDefBuilder1 = PropositionDefinition.Builder.create(null, (String)PropositionType.SIMPLE.getCode(), (String)ruleDef1.getId(), null, propositionParameterBuilderList);
        propositionDefBuilder1.setDescription("propositionDefBuilder1 Description");
        for (PropositionParameter.Builder propositionParamBuilder : propositionParameterBuilderList) {
            propositionParamBuilder.setProposition(propositionDefBuilder1);
        }
        return propositionDefBuilder1;
    }

    private TermDefinition createTermDefinition1(ContextDefinition contextDefinition) {
        TermSpecificationDefinition campusCodeTermSpec = TermSpecificationDefinition.Builder.create(null, (String)TERM_NAME, (String)contextDefinition.getId(), (String)"java.lang.String").build();
        campusCodeTermSpec = this.termBoService.createTermSpecification(campusCodeTermSpec);
        TermDefinition termDefinition1 = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)campusCodeTermSpec), null).build();
        termDefinition1 = this.termBoService.createTerm(termDefinition1);
        return termDefinition1;
    }

    private TermDefinition createTermDefinitionInteger(ContextDefinition contextDefinition) {
        TermSpecificationDefinition termSpec = TermSpecificationDefinition.Builder.create(null, (String)TERM_NAME, (String)contextDefinition.getId(), (String)"java.lang.Integer").build();
        termSpec = this.termBoService.createTermSpecification(termSpec);
        TermDefinition termDefinition1 = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpec), null).build();
        termDefinition1 = this.termBoService.createTerm(termDefinition1);
        return termDefinition1;
    }

    private KrmsAttributeDefinitionBo createEventAttributeDefinition() {
        KrmsAttributeDefinitionService service = (KrmsAttributeDefinitionService)KrmsServiceLocatorInternal.getService((String)"krmsAttributeDefinitionService");
        Assert.assertNotNull((Object)service);
        KrmsAttributeDefinitionBo attributeDefinitionBo = new KrmsAttributeDefinitionBo();
        attributeDefinitionBo.setNamespace("KR-RULE");
        attributeDefinitionBo.setName(EVENT_ATTRIBUTE);
        attributeDefinitionBo.setLabel(EVENT_ATTRIBUTE);
        attributeDefinitionBo.setActive(true);
        attributeDefinitionBo = (KrmsAttributeDefinitionBo)this.getDataObjectService().save((Object)attributeDefinitionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)attributeDefinitionBo.getId());
        return attributeDefinitionBo;
    }

    private AgendaBo createAgenda(RuleBo ruleBo, ContextBo contextBo, KrmsAttributeDefinitionBo eventAttributeDefinition) {
        AgendaBo agendaBo = new AgendaBo();
        agendaBo.setActive(true);
        agendaBo.setContextId(contextBo.getId());
        agendaBo.setName("MyAgenda");
        agendaBo.setTypeId(null);
        agendaBo = (AgendaBo)this.getDataObjectService().save((Object)agendaBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        AgendaItemBo agendaItemBo = new AgendaItemBo();
        agendaItemBo.setRule(ruleBo);
        agendaItemBo.setAgendaId(agendaBo.getId());
        agendaItemBo = (AgendaItemBo)this.getDataObjectService().save((Object)agendaItemBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        ArrayList<AgendaItemBo> agendaItems = new ArrayList<AgendaItemBo>();
        agendaItems.add(agendaItemBo);
        agendaBo.setItems(agendaItems);
        agendaBo.setFirstItemId(agendaItemBo.getId());
        agendaBo.setFirstItem(agendaItemBo);
        HashSet<AgendaAttributeBo> agendaAttributes = new HashSet<AgendaAttributeBo>();
        agendaBo.setAttributeBos(agendaAttributes);
        AgendaAttributeBo agendaAttribute = new AgendaAttributeBo();
        agendaAttributes.add(agendaAttribute);
        agendaAttribute.setAttributeDefinition(eventAttributeDefinition);
        agendaAttribute.setValue(EVENT_ATTRIBUTE);
        agendaAttribute.setAgenda(agendaBo);
        agendaBo = (AgendaBo)this.getDataObjectService().save((Object)agendaBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        contextBo.getAgendas().add(agendaBo);
        return agendaBo;
    }

    class KrmsAttributeTypeDefinitionAndBuilders {
        KrmsTypeDefinition typeDef;
        KrmsTypeDefinition.Builder typeDefBuilder;
        KrmsAttributeDefinition attribDef;
        KrmsTypeAttribute.Builder typeAttribBuilder;

        KrmsAttributeTypeDefinitionAndBuilders(KrmsAttributeDefinition krmsAttributeDefinition, KrmsTypeAttribute.Builder krmsAttributeDefinitionBuilder, KrmsTypeDefinition krmsTypeDefinition, KrmsTypeDefinition.Builder krmsTypeDefinitionBuilder) {
            this.typeDef = krmsTypeDefinition;
            this.typeDefBuilder = krmsTypeDefinitionBuilder;
            this.attribDef = krmsAttributeDefinition;
            this.typeAttribBuilder = krmsAttributeDefinitionBuilder;
        }
    }
}

