/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.ClientAppServiceSharedPayloadObj;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class DelayedAsynchronousServiceTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    @Override
    public boolean startClient2() {
        return true;
    }

    @Test
    public void testDelayedAsynchronousServiceCall() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("testAppsSharedQueue", "sharedQueue");
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (Serializable)((Object)"context"), "value1", "value2", 5000L);
        testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
        this.verifyServiceCalls(serviceName, false);
        Thread.sleep(1000L);
        this.verifyServiceCalls(serviceName, false);
        Thread.sleep(1000L);
        this.verifyServiceCalls(serviceName, false);
        Thread.sleep(1000L);
        this.verifyServiceCalls(serviceName, false);
        Thread.sleep(1000L);
        this.verifyServiceCalls(serviceName, false);
        Thread.sleep(3000L);
        this.verifyServiceCalls(serviceName, true);
    }

    private void verifyServiceCalls(QName serviceName, boolean shouldHaveBeenCalled) throws Exception {
        BAMService bamService = KSBServiceLocator.getBAMService();
        List bamCalls = bamService.getCallsForService(serviceName);
        if (!shouldHaveBeenCalled) {
            Assert.assertTrue((String)"A service call should not have been recorded yet.", (bamCalls.size() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"No service call recorded", (bamCalls.size() > 0 ? 1 : 0) != 0);
            boolean foundClientCall = false;
            boolean foundServiceCall = false;
            for (BAMTargetEntry bamEntry : bamCalls) {
                if (bamEntry.getServerInvocation().booleanValue()) {
                    foundServiceCall = true;
                    continue;
                }
                foundClientCall = true;
            }
            Assert.assertTrue((String)"No client call recorded", (boolean)foundClientCall);
            Assert.assertTrue((String)"No service call recorded", (boolean)foundServiceCall);
            Assert.assertEquals((String)"Wrong number of calls recorded", (long)2L, (long)bamCalls.size());
        }
    }
}

