/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.exceptionhandling;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.exceptionhandling.DefaultExceptionServiceImpl;
import org.kuali.rice.test.TestUtilities;

public class TestExceptionHandlerServiceImpl
extends DefaultExceptionServiceImpl {
    private static final Logger LOG = LogManager.getLogger(TestExceptionHandlerServiceImpl.class);

    public void placeInExceptionRouting(Throwable throwable, PersistedMessageBO message, Object service) {
        LOG.info("Executing placeInExceptionRouting - creating and starting the ExceptionThreader");
        ExceptionThreader exceptionThreader = new ExceptionThreader(throwable, message, service, this);
        exceptionThreader.start();
    }

    public void callRealPlaceInExceptionRouting(Throwable throwable, PersistedMessageBO message, Object service) throws Exception {
        LOG.info("Executing callRealPlaceInExceptionRouting from TestExceptionHandlerServiceImpl.");
        super.placeInExceptionRouting(throwable, message, service);
        LOG.info("Message was successfully placed in exception routing.");
    }

    private static class ExceptionThreader
    extends Thread {
        private Throwable throwable;
        private PersistedMessageBO message;
        private Object service;
        private TestExceptionHandlerServiceImpl testExceptionService;

        public ExceptionThreader(Throwable throwable, PersistedMessageBO message, Object service, TestExceptionHandlerServiceImpl testExceptionService) {
            this.throwable = throwable;
            this.message = message;
            this.service = service;
            this.testExceptionService = testExceptionService;
            TestUtilities.setExceptionThreader((Thread)this);
        }

        @Override
        public void run() {
            LOG.info("Running the ExceptionThreader - sleeping for 3 seconds - " + this.toString());
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                LOG.info("Executing 'real' placeInExceptionRouting from ExceptionThreader.");
                this.testExceptionService.callRealPlaceInExceptionRouting(this.throwable, this.message, this.service);
            }
            catch (Throwable t) {
                LOG.fatal("Error executing callRealPlaceInExceptionRouting.", t);
            }
        }
    }
}

