/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.resourceloading;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.impl.config.property.ConfigParserImplConfig;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.ksb.messaging.resourceloader.KSBResourceLoaderFactory;
import org.kuali.rice.ksb.test.KSBTestCase;

public class KSBResourceLoaderFactoryTest
extends KSBTestCase {
    private static String simpleConfig = "SIMPLE_CONFIG";
    private static String jaxbConfig = "JAXB_CONFIG";

    protected Config getConfigObject(String configType, Properties p) {
        ConfigParserImplConfig cRet = null;
        if (simpleConfig.equals(configType)) {
            cRet = new ConfigParserImplConfig(p);
        } else if (jaxbConfig.equals(configType)) {
            cRet = new JAXBConfigImpl(p);
        }
        return cRet;
    }

    @Test
    public void testCreateKSBResourceLoader() throws Exception {
        this.createKSBResourceLoaderImpl(simpleConfig);
        this.createKSBResourceLoaderImpl(jaxbConfig);
    }

    protected void createKSBResourceLoaderImpl(String configType) throws Exception {
        String me = "TestME";
        Properties props = new Properties();
        props.put("application.id", me);
        Config config = this.getConfigObject(configType, props);
        config.parseConfig();
        ConfigContext.init((Config)config);
        ResourceLoader rl = KSBResourceLoaderFactory.createRootKSBRemoteResourceLoader();
        Assert.assertNotNull((Object)rl.getResourceLoader(KSBResourceLoaderFactory.getRemoteResourceLoaderName()));
    }

    @Test
    public void testCreateKSBResourceLoaderNoApplicationId() throws Exception {
        this.createKSBResourceLoaderNoApplicationIdImpl(simpleConfig);
        this.createKSBResourceLoaderNoApplicationIdImpl(jaxbConfig);
    }

    protected void createKSBResourceLoaderNoApplicationIdImpl(String configType) throws Exception {
        Properties props = new Properties();
        Config config = this.getConfigObject(configType, props);
        config.parseConfig();
        ConfigContext.init((Config)config);
        boolean errorThrown = false;
        try {
            KSBResourceLoaderFactory.createRootKSBRemoteResourceLoader();
            Assert.fail((String)"should have thrown configuration exception with no applicationId present");
        }
        catch (IllegalStateException ce) {
            errorThrown = true;
        }
        Assert.assertTrue((boolean)errorThrown);
    }
}

