/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.security.admin.MockJavaSecurityManagementService;
import org.kuali.rice.ksb.test.KSBTestCase;

public class JavaSecurityManagementServiceTest
extends KSBTestCase {
    private static final String TEST_CLIENT_ALIAS = "test_alias";
    private static final String TEST_CLIENT_PASSWORD = "test_password";
    private static final String MOCK_JAVA_SECURITY_MANAGEMENT_SERVICE_BEAN_ID = "testJavaSecurityManagementService";

    private MockJavaSecurityManagementService getMockJavaSecurityManagementService() {
        QName serviceName = new QName("KEW", MOCK_JAVA_SECURITY_MANAGEMENT_SERVICE_BEAN_ID);
        return (MockJavaSecurityManagementService)GlobalResourceLoader.getService((QName)serviceName);
    }

    @Test
    public void testCertificatesExistInKeyStores() throws Exception {
        MockJavaSecurityManagementService securityService = this.getMockJavaSecurityManagementService();
        String moduleKeyStoreAlias = securityService.getModuleKeyStoreAlias();
        KeyStore clientKeyStore = securityService.generateClientKeystore(TEST_CLIENT_ALIAS, TEST_CLIENT_PASSWORD);
        this.verifyKeyStoreContents(clientKeyStore, "client", moduleKeyStoreAlias, TEST_CLIENT_ALIAS);
        Assert.assertEquals((String)"Certs do not match in client keystore file", (Object)securityService.getCertificate(moduleKeyStoreAlias), (Object)clientKeyStore.getCertificate(moduleKeyStoreAlias));
        this.verifyKeyStoreContents(securityService.getModuleKeyStore(), "module", TEST_CLIENT_ALIAS, securityService.getModuleKeyStoreAlias());
        Assert.assertEquals((String)"Certs do not match in module keystore file", (Object)clientKeyStore.getCertificate(moduleKeyStoreAlias), (Object)securityService.getCertificate(moduleKeyStoreAlias));
    }

    private void verifyKeyStoreContents(KeyStore keyStore, String keyStoreQualifier, String certificateEntryAlias, String privateKeyEntryAlias) throws GeneralSecurityException {
        Assert.assertTrue((String)("Alias for Certificate Entry '" + certificateEntryAlias + "' should exist in " + keyStoreQualifier + " keystore file"), (boolean)keyStore.containsAlias(certificateEntryAlias));
        Assert.assertTrue((String)("Alias '" + certificateEntryAlias + "' should be Certificate Entry in " + keyStoreQualifier + " keystore file"), (boolean)keyStore.isCertificateEntry(certificateEntryAlias));
        Assert.assertTrue((String)("Alias for Private Key Entry '" + privateKeyEntryAlias + "' should exist in " + keyStoreQualifier + " keystore file"), (boolean)keyStore.containsAlias(privateKeyEntryAlias));
        Assert.assertTrue((String)("Alias '" + privateKeyEntryAlias + "' should be Private Key Entry in " + keyStoreQualifier + " keystore file"), (boolean)keyStore.entryInstanceOf(privateKeyEntryAlias, KeyStore.PrivateKeyEntry.class));
    }
}

