/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.kuali.rice.ksb.security.admin.MockJavaSecurityManagementService;
import org.kuali.rice.ksb.security.admin.service.impl.JavaSecurityManagementServiceImpl;

public class MockJavaSecurityManagementServiceImpl
extends JavaSecurityManagementServiceImpl
implements MockJavaSecurityManagementService {
    private static final String FAKE_KEYSTORE_ALIAS = "test_keystore_alias";
    private static final String FAKE_KEYSTORE_PASSWORD = "test_keystore_pass";
    private KeyStore moduleKeyStore;
    private PrivateKey modulePrivateKey;

    public void afterPropertiesSet() throws Exception {
    }

    private void setUpService() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(512);
            KeyPair pair = keyGen.generateKeyPair();
            this.modulePrivateKey = pair.getPrivate();
            Certificate cert = this.generateCertificate(pair, this.getModuleKeyStoreAlias());
            this.moduleKeyStore = this.generateKeyStore(cert, pair.getPrivate(), this.getModuleKeyStoreAlias(), this.getModuleKeyStorePassword());
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getModuleKeyStoreLocation() {
        throw new RuntimeException("KeyStoreLocation should not be needed in unit tests");
    }

    public String getModuleKeyStoreAlias() {
        return FAKE_KEYSTORE_ALIAS;
    }

    @Override
    public String getModuleKeyStorePassword() {
        return FAKE_KEYSTORE_PASSWORD;
    }

    @Override
    public KeyStore getModuleKeyStore() {
        if (this.moduleKeyStore == null) {
            this.setUpService();
        }
        return this.moduleKeyStore;
    }

    public PrivateKey getModulePrivateKey() {
        if (this.modulePrivateKey == null) {
            this.setUpService();
        }
        return this.modulePrivateKey;
    }
}

