/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.api.exception;

/**
 * This class represents a delivery exception - when notifications are not properly delivered 
 * to their target audiences.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class MessageDeliveryException extends MessageDeliveryProcessingException {
    /**
     * Constructs a MessageDeliveryException instance.
     */
    public MessageDeliveryException() {
        super();
    }

    /**
     * Constructs a MessageDeliveryException instance.
     * @param message
     * @param cause
     */
    public MessageDeliveryException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a MessageDeliveryException instance.
     * @param message
     */
    public MessageDeliveryException(String message) {
        super(message);
    }

    /**
     * Constructs a MessageDeliveryException instance.
     * @param cause
     */
    public MessageDeliveryException(Throwable cause) {
        super(cause);
    }
}
