/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.api;

import org.kuali.rice.core.api.CoreConstants;

/**
 * Names of services published on the bus 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class KenApiConstants {
    public static final String KENAPI_SERVICE = "KEN-KENAPIService";

    public final static String SERVICE_PATH_SOAP = "soap/" + Namespaces.MODULE_NAME + "/" + CoreConstants.Versions.VERSION_2_0;


    public static final class Namespaces {
        public static final String MODULE_NAME = "ken";

        public static final String KEN_NAMESPACE_PREFIX = CoreConstants.Namespaces.ROOT_NAMESPACE_PREFIX + "/ken";

        /**
         * Namespace for the core module which is compatible with Kuali Rice 2.0.x.
         */
        public static final String KEN_NAMESPACE_2_0 = KEN_NAMESPACE_PREFIX + "/" + CoreConstants.Versions.VERSION_2_0;

        public static final String CODE = "KR-NTFCN";

        private Namespaces() {
            throw new UnsupportedOperationException("do not call");
        }
    }

    public static final class ServiceNames {
        public static final String SEND_NOTIFICATION_SERVICE = "sendNotificationService";
    }

    public static final class NotificationConstants {

    }

    public static final class RESPONSE_STATUSES {
        public static final String SUCCESS = "Success";
        public static final String FAILURE = "Failure";

        private RESPONSE_STATUSES() {
            throw new UnsupportedOperationException("do not call");
        }
    }

    public static final class KIMTypes {
        public static final class Channel {
            public static final String CHANNEL_ID = "Channel ID";

            private Channel() {
                throw new UnsupportedOperationException("do not call");
            }
        }

        private KIMTypes() {
            throw new UnsupportedOperationException("do not call");
        }
    }

    public static final class Permissions {

        public static final String VIEW_NOTIFICATION = "View Notification";

        private Permissions() {
            throw new UnsupportedOperationException("do not call");
        }
    }

    private KenApiConstants() {
        throw new UnsupportedOperationException("do not call");
    }
}
