/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.document;

import org.kuali.rice.core.api.mo.common.Coded;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * A DocumentStatusCategory is a grouping of document statuses that is searchable
 * on the document search screen.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@XmlRootElement(name = "documentStatusCategory")
@XmlType(name = "DocumentStatusCategoryType")
@XmlEnum
public enum DocumentStatusCategory implements Coded {

    @XmlEnumValue("P") PENDING("P", "Pending"),
    @XmlEnumValue("S") SUCCESSFUL("S", "Successful"),
    @XmlEnumValue("U") UNSUCCESSFUL("U", "Unsuccessful");

	private final String code;
    private final String label;

	private DocumentStatusCategory(String code, String label) {
		this.code = code;
        this.label = label;
	}
	
	@Override
	public String getCode() {
		return code;
	}
	
	public String getLabel() {
	    return label;
	}
	
	public static DocumentStatusCategory fromCode(String code) {
		if (code == null) {
			return null;
		}
		for (DocumentStatusCategory status : values()) {
			if (status.code.equals(code)) {
				return status;
			}
		}
		throw new IllegalArgumentException("Failed to locate the DocumentStatusCategory with the given code: " + code);
	}
	
}
