/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.document;

import org.joda.time.DateTime;

public interface DocumentStatusTransitionContract {
    /**
     * The unique id of the DocumentStatusTransition.
     *
     * @return id
     */
    String getId();

    /**
     * The id parent document of the DocumentStatusTransition.
     *
     * @return documentId
     */
	String getDocumentId();

    /**
     * The previous status value of the DocumentStatusTransition.
     *
     * @return oldStatus
     */
	String getOldStatus();

    /**
     * The new status value of the DocumentStatusTransition.
     *
     * @return newStatus
     */
	String getNewStatus();

    /**
     * The date of the DocumentStatusTransition.
     *
     * @return statusTransitionDate
     */
	DateTime getStatusTransitionDate();
}
