/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.document.attribute;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Defines the valid data types for implementations of the {@link DocumentAttributeContract}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@XmlRootElement(name = "documentAttributeDataType")
@XmlType(name = "DocumentAttributeDataTypeType")
@XmlEnum
public enum DocumentAttributeDataType {

    /**
     * Indicates a document attribute which holds character data.
     */
    STRING,

    /**
     * Indicates a document attribute which holds date and (optional) time information.
     */
    DATE_TIME,

    /**
     * Indicates a document attribute which holds an integer value.
     */
    INTEGER,

    /**
     * Indicates a document attribute which holds a real number.
     */
    DECIMAL

}
