/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.api.rule.RuleTemplateAttributeContract;
import org.kuali.rice.kew.api.rule.RuleTemplateContract;
import org.kuali.rice.kew.api.rule.RuleTemplateOption;
import org.kuali.rice.kew.api.rule.RuleTemplateOptionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="ruleTemplate")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RuleTemplateType", propOrder={"name", "description", "delegationTemplate", "ruleTemplateAttributes", "ruleTemplateOptions", "id", "versionNumber", "objectId", "_futureElements"})
public final class RuleTemplate
extends AbstractDataTransferObject
implements RuleTemplateContract {
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="delegationTemplate", required=false)
    private final RuleTemplate delegationTemplate;
    @XmlElementWrapper(name="ruleTemplateAttributes", required=false)
    @XmlElement(name="ruleTemplateAttribute", required=false)
    private final List<RuleTemplateAttribute> ruleTemplateAttributes;
    @XmlElementWrapper(name="ruleTemplateOptions", required=false)
    @XmlElement(name="ruleTemplateOption", required=false)
    private final List<RuleTemplateOption> ruleTemplateOptions;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RuleTemplate() {
        this.name = null;
        this.description = null;
        this.delegationTemplate = null;
        this.ruleTemplateAttributes = null;
        this.ruleTemplateOptions = null;
        this.id = null;
        this.versionNumber = null;
        this.objectId = null;
    }

    private RuleTemplate(Builder builder) {
        this.name = builder.getName();
        this.description = builder.getDescription();
        RuleTemplate ruleTemplate = this.delegationTemplate = builder.getDelegationTemplate() == null ? null : builder.getDelegationTemplate().build();
        if (CollectionUtils.isNotEmpty(builder.getRuleTemplateAttributes())) {
            ArrayList<RuleTemplateAttribute> rta = new ArrayList<RuleTemplateAttribute>();
            for (RuleTemplateAttribute.Builder attribute : builder.getRuleTemplateAttributes()) {
                rta.add(attribute.build());
            }
            this.ruleTemplateAttributes = Collections.unmodifiableList(rta);
        } else {
            this.ruleTemplateAttributes = Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(builder.getRuleTemplateOptions())) {
            ArrayList<RuleTemplateOption> rto = new ArrayList<RuleTemplateOption>();
            for (RuleTemplateOption.Builder option : builder.getRuleTemplateOptions()) {
                rto.add(option.build());
            }
            this.ruleTemplateOptions = Collections.unmodifiableList(rto);
        } else {
            this.ruleTemplateOptions = Collections.emptyList();
        }
        this.id = builder.getId();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public RuleTemplate getDelegationTemplate() {
        return this.delegationTemplate;
    }

    public List<RuleTemplateAttribute> getRuleTemplateAttributes() {
        return this.ruleTemplateAttributes;
    }

    public List<RuleTemplateAttribute> getActiveRuleTemplateAttributes() {
        ArrayList<RuleTemplateAttribute> activeAttributes = new ArrayList<RuleTemplateAttribute>();
        for (RuleTemplateAttribute templateAttribute : this.getRuleTemplateAttributes()) {
            if (!templateAttribute.isActive()) continue;
            activeAttributes.add(templateAttribute);
        }
        Collections.sort(activeAttributes);
        return activeAttributes;
    }

    public List<RuleTemplateOption> getRuleTemplateOptions() {
        return this.ruleTemplateOptions;
    }

    public String getId() {
        return this.id;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RuleTemplateContract {
        private String name;
        private String description;
        private Builder delegationTemplate;
        private List<RuleTemplateAttribute.Builder> ruleTemplateAttributes;
        private List<RuleTemplateOption.Builder> ruleTemplateOptions;
        private String id;
        private Long versionNumber;
        private String objectId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(RuleTemplateContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setName(contract.getName());
            builder.setDescription(contract.getDescription());
            builder.setDelegationTemplate(contract.getDelegationTemplate() == null ? null : Builder.create(contract.getDelegationTemplate()));
            if (CollectionUtils.isNotEmpty(contract.getRuleTemplateAttributes())) {
                ArrayList<RuleTemplateAttribute.Builder> attrs = new ArrayList<RuleTemplateAttribute.Builder>();
                for (RuleTemplateAttributeContract ruleTemplateAttributeContract : contract.getRuleTemplateAttributes()) {
                    attrs.add(RuleTemplateAttribute.Builder.create(ruleTemplateAttributeContract));
                }
                builder.setRuleTemplateAttributes(attrs);
            } else {
                builder.setRuleTemplateAttributes(Collections.emptyList());
            }
            if (CollectionUtils.isNotEmpty(contract.getRuleTemplateOptions())) {
                ArrayList<RuleTemplateOption.Builder> options = new ArrayList<RuleTemplateOption.Builder>();
                for (RuleTemplateOptionContract ruleTemplateOptionContract : contract.getRuleTemplateOptions()) {
                    options.add(RuleTemplateOption.Builder.create(ruleTemplateOptionContract));
                }
                builder.setRuleTemplateOptions(options);
            } else {
                builder.setRuleTemplateOptions(Collections.emptyList());
            }
            builder.setId(contract.getId());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public RuleTemplate build() {
            return new RuleTemplate(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Builder getDelegationTemplate() {
            return this.delegationTemplate;
        }

        public List<RuleTemplateAttribute.Builder> getRuleTemplateAttributes() {
            return this.ruleTemplateAttributes;
        }

        public List<RuleTemplateOption.Builder> getRuleTemplateOptions() {
            return this.ruleTemplateOptions;
        }

        public String getId() {
            return this.id;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is null or blank");
            }
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setDelegationTemplate(Builder delegationTemplate) {
            this.delegationTemplate = delegationTemplate;
        }

        public void setRuleTemplateAttributes(List<RuleTemplateAttribute.Builder> ruleTemplateAttributes) {
            this.ruleTemplateAttributes = Collections.unmodifiableList(ruleTemplateAttributes);
        }

        public void setRuleTemplateOptions(List<RuleTemplateOption.Builder> ruleTemplateOptions) {
            this.ruleTemplateOptions = Collections.unmodifiableList(ruleTemplateOptions);
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id was whitespace");
            }
            this.id = id;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kew/v2_0/RuleTemplateType";
    }

    static class Elements {
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String DELEGATION_TEMPLATE = "delegationTemplate";
        static final String RULE_TEMPLATE_ATTRIBUTES = "ruleTemplateAttributes";
        static final String RULE_TEMPLATE_OPTIONS = "ruleTemplateOptions";
        static final String RULE_TEMPLATE_ATTRIBUTE = "ruleTemplateAttribute";
        static final String RULE_TEMPLATE_OPTION = "ruleTemplateOption";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "ruleTemplate";
        static final String TYPE_NAME = "RuleTemplateType";

        Constants() {
        }
    }
}

