/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kew.api.action.ActionRequestContract;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.RecipientType;
import org.w3c.dom.Element;

@XmlRootElement(name="actionRequest")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ActionRequestType", propOrder={"id", "actionRequestedCode", "statusCode", "current", "dateCreated", "responsibilityId", "documentId", "priority", "routeLevel", "annotation", "recipientTypeCode", "principalId", "groupId", "requestPolicyCode", "responsibilityDescription", "forceAction", "delegationTypeCode", "roleName", "qualifiedRoleName", "qualifiedRoleNameLabel", "routeNodeInstanceId", "nodeName", "requestLabel", "parentActionRequestId", "actionTaken", "childRequests", "_futureElements"})
public final class ActionRequest
extends AbstractDataTransferObject
implements ActionRequestContract {
    private static final long serialVersionUID = -7581089059447119201L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="actionRequestedCode", required=true)
    private final String actionRequestedCode;
    @XmlElement(name="statusCode", required=true)
    private final String statusCode;
    @XmlElement(name="current", required=true)
    private final boolean current;
    @XmlElement(name="dateCreated", required=true)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateCreated;
    @XmlElement(name="responsibilityId", required=true)
    private final String responsibilityId;
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElement(name="priority", required=true)
    private final int priority;
    @XmlElement(name="routeLevel", required=true)
    private final int routeLevel;
    @XmlElement(name="annotation", required=false)
    private final String annotation;
    @XmlElement(name="recipientTypeCode", required=true)
    private final String recipientTypeCode;
    @XmlElement(name="principalId", required=false)
    private final String principalId;
    @XmlElement(name="groupId", required=false)
    private final String groupId;
    @XmlElement(name="requestPolicyCode", required=false)
    private final String requestPolicyCode;
    @XmlElement(name="responsibilityDescription", required=false)
    private final String responsibilityDescription;
    @XmlElement(name="forceAction", required=true)
    private final boolean forceAction;
    @XmlElement(name="delegationTypeCode", required=false)
    private final String delegationTypeCode;
    @XmlElement(name="roleName", required=false)
    private final String roleName;
    @XmlElement(name="qualifiedRoleName", required=false)
    private final String qualifiedRoleName;
    @XmlElement(name="qualifiedRoleNameLabel", required=false)
    private final String qualifiedRoleNameLabel;
    @XmlElement(name="routeNodeInstanceId", required=false)
    private final String routeNodeInstanceId;
    @XmlElement(name="nodeName", required=false)
    private final String nodeName;
    @XmlElement(name="requestLabel", required=false)
    private final String requestLabel;
    @XmlElement(name="parentActionRequestId", required=false)
    private final String parentActionRequestId;
    @XmlElement(name="actionTaken", required=false)
    private final ActionTaken actionTaken;
    @XmlElementWrapper(name="childRequests", required=false)
    @XmlElement(name="childRequest", required=false)
    private final List<ActionRequest> childRequests;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ActionRequest() {
        this.id = null;
        this.actionRequestedCode = null;
        this.statusCode = null;
        this.current = false;
        this.dateCreated = null;
        this.responsibilityId = null;
        this.documentId = null;
        this.priority = 0;
        this.routeLevel = 0;
        this.annotation = null;
        this.recipientTypeCode = null;
        this.principalId = null;
        this.groupId = null;
        this.requestPolicyCode = null;
        this.responsibilityDescription = null;
        this.forceAction = false;
        this.delegationTypeCode = null;
        this.roleName = null;
        this.qualifiedRoleName = null;
        this.qualifiedRoleNameLabel = null;
        this.routeNodeInstanceId = null;
        this.nodeName = null;
        this.requestLabel = null;
        this.parentActionRequestId = null;
        this.actionTaken = null;
        this.childRequests = null;
    }

    private ActionRequest(Builder builder) {
        this.id = builder.getId();
        this.actionRequestedCode = builder.getActionRequested().getCode();
        this.statusCode = builder.getStatus().getCode();
        this.current = builder.isCurrent();
        this.dateCreated = builder.getDateCreated();
        this.responsibilityId = builder.getResponsibilityId();
        this.documentId = builder.getDocumentId();
        this.priority = builder.getPriority();
        this.routeLevel = builder.getRouteLevel();
        this.annotation = builder.getAnnotation();
        this.recipientTypeCode = builder.getRecipientType().getCode();
        this.principalId = builder.getPrincipalId();
        this.groupId = builder.getGroupId();
        this.requestPolicyCode = builder.getRequestPolicy() == null ? null : builder.getRequestPolicy().getCode();
        this.responsibilityDescription = builder.getResponsibilityDescription();
        this.forceAction = builder.isForceAction();
        this.delegationTypeCode = builder.getDelegationType() == null ? null : builder.getDelegationType().getCode();
        this.roleName = builder.getRoleName();
        this.qualifiedRoleName = builder.getQualifiedRoleName();
        this.qualifiedRoleNameLabel = builder.getQualifiedRoleNameLabel();
        this.routeNodeInstanceId = builder.getRouteNodeInstanceId();
        this.nodeName = builder.getNodeName();
        this.requestLabel = builder.getRequestLabel();
        this.parentActionRequestId = builder.getParentActionRequestId();
        ActionTaken.Builder actionTakenBuilder = builder.getActionTaken();
        this.actionTaken = actionTakenBuilder == null ? null : actionTakenBuilder.build();
        this.childRequests = new ArrayList<ActionRequest>();
        List<Builder> childRequestBuilders = builder.getChildRequests();
        if (childRequestBuilders != null) {
            for (Builder childRequestBuilder : childRequestBuilders) {
                this.childRequests.add(childRequestBuilder.build());
            }
        }
    }

    @Override
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getRouteLevel() {
        return this.routeLevel;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ActionRequestType getActionRequested() {
        return ActionRequestType.fromCode(this.actionRequestedCode);
    }

    @Override
    public ActionRequestStatus getStatus() {
        return ActionRequestStatus.fromCode(this.statusCode);
    }

    @Override
    public boolean isCurrent() {
        return this.current;
    }

    @Override
    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public RecipientType getRecipientType() {
        return RecipientType.fromCode(this.recipientTypeCode);
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public ActionRequestPolicy getRequestPolicy() {
        if (this.requestPolicyCode == null) {
            return null;
        }
        return ActionRequestPolicy.fromCode(this.requestPolicyCode);
    }

    @Override
    public String getResponsibilityDescription() {
        return this.responsibilityDescription;
    }

    @Override
    public boolean isForceAction() {
        return this.forceAction;
    }

    @Override
    public DelegationType getDelegationType() {
        if (this.delegationTypeCode == null) {
            return null;
        }
        return DelegationType.fromCode((String)this.delegationTypeCode);
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public String getQualifiedRoleName() {
        return this.qualifiedRoleName;
    }

    @Override
    public String getQualifiedRoleNameLabel() {
        return this.qualifiedRoleNameLabel;
    }

    @Override
    public String getRouteNodeInstanceId() {
        return this.routeNodeInstanceId;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getRequestLabel() {
        return this.requestLabel;
    }

    @Override
    public String getParentActionRequestId() {
        return this.parentActionRequestId;
    }

    @Override
    public ActionTaken getActionTaken() {
        return this.actionTaken;
    }

    public List<ActionRequest> getChildRequests() {
        if (this.childRequests == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.childRequests);
    }

    public boolean isAdHocRequest() {
        return "-1".equals(this.getResponsibilityId());
    }

    public boolean isGeneratedRequest() {
        return "0".equals(this.getResponsibilityId());
    }

    public boolean isExceptionRequest() {
        return "-2".equals(this.getResponsibilityId());
    }

    public boolean isRouteModuleRequest() {
        return this.getResponsibilityId() != null && Long.parseLong(this.getResponsibilityId()) > 0L;
    }

    public boolean isNotificationRequest() {
        return this.isAcknowledgeRequest() || this.isFyiRequest();
    }

    public boolean isApprovalRequest() {
        return ActionRequestType.APPROVE == this.getActionRequested() || ActionRequestType.COMPLETE == this.getActionRequested();
    }

    public boolean isAcknowledgeRequest() {
        return ActionRequestType.ACKNOWLEDGE == this.getActionRequested();
    }

    public boolean isFyiRequest() {
        return ActionRequestType.FYI == this.getActionRequested();
    }

    public boolean isPending() {
        return this.isInitialized() || this.isActivated();
    }

    public boolean isCompleteRequest() {
        return ActionRequestType.COMPLETE == this.getActionRequested();
    }

    public boolean isInitialized() {
        return ActionRequestStatus.INITIALIZED == this.getStatus();
    }

    public boolean isActivated() {
        return ActionRequestStatus.ACTIVATED == this.getStatus();
    }

    public boolean isDone() {
        return ActionRequestStatus.DONE == this.getStatus();
    }

    public boolean isUserRequest() {
        return RecipientType.PRINCIPAL == this.getRecipientType();
    }

    public boolean isGroupRequest() {
        return RecipientType.GROUP == this.getRecipientType();
    }

    public boolean isRoleRequest() {
        return RecipientType.ROLE == this.getRecipientType();
    }

    public List<ActionRequest> flatten() {
        ArrayList<ActionRequest> flattenedRequests = new ArrayList<ActionRequest>();
        flattenedRequests.add(this);
        for (ActionRequest childRequest : this.getChildRequests()) {
            flattenedRequests.addAll(childRequest.flatten());
        }
        return Collections.unmodifiableList(flattenedRequests);
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    ActionRequestContract {
        private static final long serialVersionUID = -1354211147778354091L;
        private String id;
        private ActionRequestType actionRequested;
        private ActionRequestStatus status;
        private boolean current;
        private DateTime dateCreated;
        private String responsibilityId;
        private String documentId;
        private int priority;
        private int routeLevel;
        private String annotation;
        private RecipientType recipientType;
        private String principalId;
        private String groupId;
        private ActionRequestPolicy requestPolicy;
        private String responsibilityDescription;
        private boolean forceAction;
        private DelegationType delegationType;
        private String roleName;
        private String qualifiedRoleName;
        private String qualifiedRoleNameLabel;
        private String routeNodeInstanceId;
        private String nodeName;
        private String requestLabel;
        private String parentActionRequestId;
        private ActionTaken.Builder actionTaken;
        private List<Builder> childRequests;

        private Builder(String id, ActionRequestType actionRequested, ActionRequestStatus status, String responsibilityId, String documentId, RecipientType recipientType) {
            this.setId(id);
            this.setActionRequested(actionRequested);
            this.setStatus(status);
            this.setResponsibilityId(responsibilityId);
            this.setDocumentId(documentId);
            this.setRecipientType(recipientType);
            this.setCurrent(true);
            this.setDateCreated(new DateTime());
        }

        public static Builder create(String id, ActionRequestType actionRequested, ActionRequestStatus status, String responsibilityId, String documentId, RecipientType recipientType) {
            return new Builder(id, actionRequested, status, responsibilityId, documentId, recipientType);
        }

        public static Builder create(ActionRequestContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getId(), contract.getActionRequested(), contract.getStatus(), contract.getResponsibilityId(), contract.getDocumentId(), contract.getRecipientType());
            builder.setCurrent(contract.isCurrent());
            builder.setDateCreated(contract.getDateCreated());
            builder.setPriority(contract.getPriority());
            builder.setRouteLevel(contract.getRouteLevel());
            builder.setAnnotation(contract.getAnnotation());
            builder.setPrincipalId(contract.getPrincipalId());
            builder.setGroupId(contract.getGroupId());
            builder.setRequestPolicy(contract.getRequestPolicy());
            builder.setResponsibilityDescription(contract.getResponsibilityDescription());
            builder.setForceAction(contract.isForceAction());
            builder.setDelegationType(contract.getDelegationType());
            builder.setRoleName(contract.getRoleName());
            builder.setQualifiedRoleName(contract.getQualifiedRoleName());
            builder.setQualifiedRoleNameLabel(contract.getQualifiedRoleNameLabel());
            builder.setNodeName(contract.getNodeName());
            builder.setRequestLabel(contract.getRequestLabel());
            builder.setParentActionRequestId(contract.getParentActionRequestId());
            if (contract.getActionTaken() != null) {
                builder.setActionTaken(ActionTaken.Builder.create(contract.getActionTaken()));
            }
            ArrayList<Builder> actionRequestBuilders = new ArrayList<Builder>();
            for (ActionRequestContract actionRequestContract : contract.getChildRequests()) {
                actionRequestBuilders.add(Builder.create(actionRequestContract));
            }
            builder.setChildRequests(actionRequestBuilders);
            return builder;
        }

        public ActionRequest build() {
            return new ActionRequest(this);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public ActionRequestType getActionRequested() {
            return this.actionRequested;
        }

        @Override
        public ActionRequestStatus getStatus() {
            return this.status;
        }

        @Override
        public boolean isCurrent() {
            return this.current;
        }

        @Override
        public DateTime getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public String getResponsibilityId() {
            return this.responsibilityId;
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public int getRouteLevel() {
            return this.routeLevel;
        }

        @Override
        public String getAnnotation() {
            return this.annotation;
        }

        @Override
        public RecipientType getRecipientType() {
            return this.recipientType;
        }

        @Override
        public String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public ActionRequestPolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        @Override
        public String getResponsibilityDescription() {
            return this.responsibilityDescription;
        }

        @Override
        public boolean isForceAction() {
            return this.forceAction;
        }

        @Override
        public DelegationType getDelegationType() {
            return this.delegationType;
        }

        @Override
        public String getRoleName() {
            return this.roleName;
        }

        @Override
        public String getQualifiedRoleName() {
            return this.qualifiedRoleName;
        }

        @Override
        public String getQualifiedRoleNameLabel() {
            return this.qualifiedRoleNameLabel;
        }

        @Override
        public String getRouteNodeInstanceId() {
            return this.routeNodeInstanceId;
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }

        @Override
        public String getRequestLabel() {
            return this.requestLabel;
        }

        @Override
        public String getParentActionRequestId() {
            return this.parentActionRequestId;
        }

        @Override
        public ActionTaken.Builder getActionTaken() {
            return this.actionTaken;
        }

        public List<Builder> getChildRequests() {
            return this.childRequests;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id was null or blank");
            }
            this.id = id;
        }

        public void setActionRequested(ActionRequestType actionRequested) {
            if (actionRequested == null) {
                throw new IllegalArgumentException("actionRequested was null");
            }
            this.actionRequested = actionRequested;
        }

        public void setStatus(ActionRequestStatus status) {
            if (status == null) {
                throw new IllegalArgumentException("status was null");
            }
            this.status = status;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        public void setDateCreated(DateTime dateCreated) {
            if (dateCreated == null) {
                throw new IllegalArgumentException("dateCreated was null");
            }
            this.dateCreated = dateCreated;
        }

        public void setResponsibilityId(String responsibilityId) {
            if (StringUtils.isBlank((String)responsibilityId)) {
                throw new IllegalArgumentException("responsibilityId was null or blank");
            }
            this.responsibilityId = responsibilityId;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setRouteLevel(int routeLevel) {
            this.routeLevel = routeLevel;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public void setRecipientType(RecipientType recipientType) {
            if (recipientType == null) {
                throw new IllegalArgumentException("recipientType was null");
            }
            this.recipientType = recipientType;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setRequestPolicy(ActionRequestPolicy requestPolicy) {
            this.requestPolicy = requestPolicy;
        }

        public void setResponsibilityDescription(String responsibilityDescription) {
            this.responsibilityDescription = responsibilityDescription;
        }

        public void setForceAction(boolean forceAction) {
            this.forceAction = forceAction;
        }

        public void setDelegationType(DelegationType delegationType) {
            this.delegationType = delegationType;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public void setQualifiedRoleName(String qualifiedRoleName) {
            this.qualifiedRoleName = qualifiedRoleName;
        }

        public void setQualifiedRoleNameLabel(String qualifiedRoleNameLabel) {
            this.qualifiedRoleNameLabel = qualifiedRoleNameLabel;
        }

        public void setRouteNodeInstanceId(String routeNodeInstanceId) {
            this.routeNodeInstanceId = routeNodeInstanceId;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public void setRequestLabel(String requestLabel) {
            this.requestLabel = requestLabel;
        }

        public void setParentActionRequestId(String parentActionRequestId) {
            this.parentActionRequestId = parentActionRequestId;
        }

        public void setActionTaken(ActionTaken.Builder actionTaken) {
            this.actionTaken = actionTaken;
        }

        public void setChildRequests(List<Builder> childRequests) {
            this.childRequests = childRequests;
        }
    }

    static class Elements {
        static final String ANNOTATION = "annotation";
        static final String PRIORITY = "priority";
        static final String ID = "id";
        static final String ACTION_REQUESTED_CODE = "actionRequestedCode";
        static final String STATUS_CODE = "statusCode";
        static final String CURRENT = "current";
        static final String ROUTE_LEVEL = "routeLevel";
        static final String DATE_CREATED = "dateCreated";
        static final String RESPONSIBILITY_ID = "responsibilityId";
        static final String DOCUMENT_ID = "documentId";
        static final String RECIPIENT_TYPE_CODE = "recipientTypeCode";
        static final String PRINCIPAL_ID = "principalId";
        static final String GROUP_ID = "groupId";
        static final String REQUEST_POLICY_CODE = "requestPolicyCode";
        static final String RESPONSIBILITY_DESCRIPTION = "responsibilityDescription";
        static final String FORCE_ACTION = "forceAction";
        static final String DELEGATION_TYPE_CODE = "delegationTypeCode";
        static final String ROLE_NAME = "roleName";
        static final String QUALIFIED_ROLE_NAME = "qualifiedRoleName";
        static final String QUALIFIED_ROLE_NAME_LABEL = "qualifiedRoleNameLabel";
        static final String ROUTE_NODE_INSTANCE_ID = "routeNodeInstanceId";
        static final String NODE_NAME = "nodeName";
        static final String REQUEST_LABEL = "requestLabel";
        static final String PARENT_ACTION_REQUEST_ID = "parentActionRequestId";
        static final String ACTION_TAKEN = "actionTaken";
        static final String CHILD_REQUESTS = "childRequests";
        static final String CHILD_REQUEST = "childRequest";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "actionRequest";
        static final String TYPE_NAME = "ActionRequestType";

        Constants() {
        }
    }
}

