/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api;

import javax.xml.ws.WebFault;

/**
 * A generic runtime exception thrown from KEW.  Acts as the superclass for all runtime
 * exceptions in KEW.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@WebFault(name = "WorkflowRuntimeFault", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
public class WorkflowRuntimeException extends RuntimeException {
    
    private static final long serialVersionUID = 2012770642382150523L;
    
    public WorkflowRuntimeException(String message) {
        super(message);
    }

    public WorkflowRuntimeException() {
        super();
    }

    public WorkflowRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public WorkflowRuntimeException(Throwable cause) {
        super(cause);
    }
}
