/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.responsibility;

import org.kuali.rice.kew.api.KewApiConstants;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import java.util.Set;

@WebService(name = "responsibilityChangeQueue", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface ResponsibilityChangeQueue {

    /**
     * Notifies the workflow system that the given set of responsibility ids were updated in such a way that might
     * affect routing.  Implementation of this method should re-resolve enroute documents as neccessary in this case.
     *
     * @param responsibilityIds the set of ids of responsibilities which have been modified, if this is a null or
     * empty set then this method will do nothing
     */
    @WebMethod(operationName = "responsibilitiesChanged")
    void responsibilitiesChanged(@WebParam(name = "responsibilityIds") Set<String> responsibilityIds);
   
}
