/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.identity;

import org.kuali.rice.kew.api.user.UserId;

/**
 * The Employee ID of a Person in KIM
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class EmployeeId implements UserId {
    private static final long serialVersionUID = -1335314734556834644L;
    private String employeeId;

	public EmployeeId() {
	}

	public EmployeeId(String employeeId) {
		setEmployeeId(employeeId);
	}
	
	public String getEmployeeId() {
		return this.employeeId;
	}
	
	public void setEmployeeId(String employeeId) {
		this.employeeId = (employeeId == null ? null : employeeId.trim());
	}

    @Override
    public String getId() {
        return getEmployeeId();
    }

    /**
     * Returns true if this userId has an empty value. Empty userIds can't be used as keys in a Hash, among other things.
     *
     * @return true if this instance doesn't have a value
     */
    @Override
    public boolean isEmpty() {
    	return (employeeId == null || employeeId.trim().length() == 0);
    }

    /**
     * If you make this class non-final, you must rewrite equals to work for subclasses.
     */
    @Override
    public boolean equals(Object obj) {

        if (obj != null && (obj instanceof EmployeeId)) {
            EmployeeId a = (EmployeeId) obj;

            if (getEmployeeId() == null) {
                return false;
            }

            return employeeId.equals(a.getEmployeeId());
        }

        return false;
    }

    @Override
    public int hashCode() {
        return employeeId == null ? 0 : employeeId.hashCode();
    }

    @Override
    public String toString() {
        if (employeeId == null) {
            return "employeeId: null";
        }
        return "employeeId: " + employeeId;
    }

}
