/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.document.search;

import java.util.List;

/**
 * Defines the contract for which specifies attribute fields that should be included as part of document search criteria
 * on the document search user interface.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentSearchCriteriaConfigurationContract {

    /**
     * Returns the additional attribute fields that should be included as part of the document search criteria on the
     * document search user interface.
     *
     * @return the search attribute fields that are part of this configuration
     */
    List<AttributeFields> getSearchAttributeFields();

}
