/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

/**
 * Returned from a {@link org.kuali.rice.kew.framework.postprocessor.PostProcessor} to indicate success of failure of
 * a particular event.  If success is false then this will typically trigger
 * the document to go into exception routing.
 * 
 * @see org.kuali.rice.kew.framework.postprocessor.PostProcessor
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ProcessDocReport implements java.io.Serializable {

	static final long serialVersionUID = 376851530227478560L;

	private boolean success = false;
	private String message;
	private Exception processException = null;

	public ProcessDocReport(boolean success) {
		this(success, "");
	}

	public ProcessDocReport(boolean success, String message) {
		this.success = success;
		this.message = message;
	}

	public ProcessDocReport(boolean success, String message, Exception e) {
		this.success = success;
		this.message = message;
		this.processException = e;
	}

	public String getMessage() {
		return message;
	}

	public Exception getProcessException() {
		return processException;
	}

	public boolean isSuccess() {
		return success;
	}
}
