/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.type;


import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;

import java.util.List;
/**
 * This is a contract for EntityTypeContactInfo.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */

public interface EntityTypeContactInfoContract extends Versioned, GloballyUnique, Inactivatable {
    /**
     * Gets the id of the parent identity object.
     * @return the identity id for this {@link EntityAddressContract}
     */
    String getEntityId();

    /**
     * Gets this entityTypeCode of the {@link EntityAddressContract}'s object.
     * @return the identity type code for this {@link EntityAddressContract}
     */
    String getEntityTypeCode();

    /**
     * Gets this identity Type of the {@link EntityTypeContactInfoContract}'s object.
     * @return the identity type for this {@link EntityTypeContactInfoContract}
     */
	CodedAttributeContract getEntityType();

	/**
     * Gets this {@link EntityTypeContactInfoContract}'s List of {@link org.kuali.rice.kim.api.identity.address.EntityAddress}S.
     * @return the List of {@link org.kuali.rice.kim.api.identity.address.EntityAddressContract}S for this {@link EntityTypeContactInfoContract}.
     * The returned List will never be null, an empty List will be assigned and returned if needed. 
     */
	List<? extends EntityAddressContract> getAddresses();

	/**
     * Gets this {@link EntityTypeContactInfoContract}'s List of {@link org.kuali.rice.kim.api.identity.email.EntityEmailContract}S.
     * @return the List of {@link org.kuali.rice.kim.api.identity.email.EntityEmailContract}S for this {@link EntityTypeContactInfoContract}.
     * The returned List will never be null, an empty List will be assigned and returned if needed. 
     */
	List<? extends EntityEmailContract> getEmailAddresses();
	
	/**
     * Gets this {@link EntityTypeContactInfoContract}'s List of {@link org.kuali.rice.kim.api.identity.phone.EntityPhone}S.
     * @return the List of {@link org.kuali.rice.kim.api.identity.phone.EntityPhoneContract}S for this {@link EntityTypeContactInfoContract}.
     * The returned List will never be null, an empty List will be assigned and returned if needed. 
     */
	List<? extends EntityPhoneContract> getPhoneNumbers();
	
	/** 
	 * Returns the default address record for the identity.  If no default is defined, then
	 * it returns the first one found.  If none are defined, it returns null.
	 */
	EntityAddressContract getDefaultAddress();

	/**
	 *  Returns the default email record for the identity.  If no default is defined, then
	 * it returns the first one found.  If none are defined, it returns null.
	 */
	EntityEmailContract getDefaultEmailAddress();

	/** 
	 * Returns the default phone record for the identity.  If no default is defined, then
	 * it returns the first one found.  If none are defined, it returns null.
	 */
	EntityPhoneContract getDefaultPhoneNumber();
}
