/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.visa;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * visa information for a KIM identity
 * 
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 *
 */
public interface EntityVisaContract extends Versioned, GloballyUnique, Identifiable {

	/**
     * Gets this {@link EntityVisaContract}'s identity id.
     * @return the identity id for this {@link EntityVisaContract}, or null if none has been assigned.
     */
	String getEntityId();

    /**
     * Gets this {@link EntityVisaContract}'s visa type key.
     * @return the visa type key for this {@link EntityVisaContract}, or null if none has been assigned.
     */
	String getVisaTypeKey();
	
	/**
     * Gets this {@link EntityVisaContract}'s visa entry.
     * @return the visa entry for this {@link EntityVisaContract}, or null if none has been assigned.
     */
	String getVisaEntry();
	
	/**
     * Gets this {@link EntityVisaContract}'s visa id.
     * @return the visa id for this {@link EntityVisaContract}, or null if none has been assigned.
     */
	String getVisaId();
}
