/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.citizenship;

import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
/**
 * This contract represents the citizenship information  associated with an Entity.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface EntityCitizenshipContract extends Versioned, GloballyUnique, Inactivatable, Identifiable {
	/**
     * Gets this id of the parent identity object.
     * @return the identity id for this {@link EntityCitizenshipContract}
     */
    String getEntityId();

    /**
     * Gets this {@link EntityCitizenshipContract}'s citizenship status object.
     * @return the Type object of citizenship status for this {@link EntityCitizenshipContract}, or null if none has been assigned.
     */
	CodedAttributeContract getStatus();

	/**
     * Gets this {@link EntityCitizenshipContract}'s country code.
     * @return the country code for this {@link EntityCitizenshipContract}, or null if none has been assigned.
     */
	String getCountryCode();

	/**
     * Gets this {@link EntityCitizenshipContract}'s start date.
     * @return the start date for this {@link EntityCitizenshipContract}, or null if none has been assigned.
     */
	DateTime getStartDate();

	/**
     * Gets this {@link EntityCitizenshipContract}'s end date.
     * @return the end date for this {@link EntityCitizenshipContract}, or null if none has been assigned.
     */
	DateTime getEndDate();
}
