/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.role;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 *
 * <p>Associates a Role/Responsibility/(Group/Principal).</p>
 *
 * <p>When a person is assigned to a role with a responsibility, the UI must populate this table with this additional
 * information.</p>
 *
 * Data is an action request type (approve/acknowledge/fyi/etc...), and a priority number
 */
public interface RoleResponsibilityActionContract extends Versioned, Identifiable {

    /**
     * Id of the contained RoleResponsibility object.
     * @return A RoleResponsibility Id.  Can be null if there is no associated RoleResponsibility.
     */
    String getRoleResponsibilityId();

    /**
     * <p>A string representation of the action type to be taken on this RoleResponsibilityAction.</p>
     *
     * <p>Examples are
     * <ul>
     *     <li>"A" - Approve </li>
     *     <li>"F" - FYI </li>
     *     <li>"K" - Acknowledge </li>
     * </ul>
     *
     * @return String representing the action type.  This can be null.
     */
	String getActionTypeCode();

    /**
     * @return Integer representing the priority assigned to this Action.  This can be a null value.
     */
    Integer getPriorityNumber();

    /**
     * Returns the action policy code.
     * @return String for the policy code.  This can be null.
     */
    String getActionPolicyCode();

    /**
     * String identifier for an associated RoleMember
     * @return RoleMember identifier.  This can be null.
     */
	String getRoleMemberId();

    /**
     * Returns a RoleResponsibility instances associated with this action.
     * @return Associated RoleResponsibility - can be null.
     */
    RoleResponsibilityContract getRoleResponsibility();

    /**
     * @return Whether this action should be is forced or not.
     */
	boolean isForceAction();
}
