/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.type;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.common.attribute.KimAttributeContract;

/**
 * This is the contract for a KimTypeAttribute.  A KimTypeAttribute
 * associates a kim type with a kim attribute.
 */
public interface KimTypeAttributeContract extends Versioned, GloballyUnique, Identifiable, Inactivatable {

    /**
     * The alpha and/or numeric code used to choose an order for displaying KimTypeAttributes.  This can be null or blank.
     *
     * @return the sort code.
     */
    String getSortCode();

    /**
     * The kim attribute associated with the kim type attribute.  This can be null if no KimAttributes are associated.
     *
     * @return the kim attribute
     */
    KimAttributeContract getKimAttribute();

    /**
     * The kim type id associated with the kim type attribute.  This can be null if no KimType is associated.
     *
     * @return the kim type id
     */
    String getKimTypeId();
}
