/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.type;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

import java.util.List;

/**
 * This is the contract for a KimType.  A KimType is a metadata wrapper around a
 * kim type service which aides in attribute resolution.
 */
public interface KimTypeContract extends Versioned, GloballyUnique, Identifiable, Inactivatable {

    /**
     * The service name used to resolve attribute values.
     *
     * @return the service name
     */
    String getServiceName();

    /**
     * The namespace code that this kim type belongs too.
     *
     * @return namespace code
     */
    String getNamespaceCode();

    /**
     * The name of the kim type.
     *
     * @return the name
     */
    String getName();

    /**
     * The list of attribute definitions associated with the kim type. This cannot be null.  If no
     * attribute definitions are associated with the kim type then this will return an empty collection.
     *
     * @return the list of attribute definitions
     */
    List<? extends KimTypeAttributeContract> getAttributeDefinitions();
}
