/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.email;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class EntityEmailBase
extends DataObjectBase
implements EntityEmailContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="ENT_TYP_CD")
    private String entityTypeCode;
    @Column(name="EMAIL_TYP_CD")
    private String emailTypeCode;
    @Column(name="EMAIL_ADDR")
    private String emailAddress;
    @Transient
    private boolean suppressEmail;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="ACTV_IND")
    private boolean active;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="DFLT_IND")
    private boolean defaultValue;

    public EntityEmailBase() {
    }

    public boolean isSuppressEmail() {
        try {
            EntityPrivacyPreferences privacy = KimApiServiceLocator.getIdentityService().getEntityPrivacyPreferences(this.getEntityId());
            this.suppressEmail = privacy != null ? privacy.isSuppressEmail() : false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.suppressEmail;
    }

    public String getEmailAddressUnmasked() {
        return this._persistence_get_emailAddress();
    }

    public String getEmailAddress() {
        if (this.isSuppressEmail()) {
            return "Xxxxxx";
        }
        return this._persistence_get_emailAddress();
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public String getEntityTypeCode() {
        return this._persistence_get_entityTypeCode();
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this._persistence_set_entityTypeCode(entityTypeCode);
    }

    public String getEmailTypeCode() {
        return this._persistence_get_emailTypeCode();
    }

    public void setEmailTypeCode(String emailTypeCode) {
        this._persistence_set_emailTypeCode(emailTypeCode);
    }

    public void setEmailAddress(String emailAddress) {
        this._persistence_set_emailAddress(emailAddress);
    }

    public boolean getSuppressEmail() {
        return this.suppressEmail;
    }

    public void setSuppressEmail(boolean suppressEmail) {
        this.suppressEmail = suppressEmail;
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public boolean getDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public boolean isDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public void setDefaultValue(boolean defaultValue) {
        this._persistence_set_defaultValue(defaultValue);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityEmailBase(persistenceObject);
    }

    public EntityEmailBase(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "emailAddress") {
            return this.emailAddress;
        }
        if (string == "entityTypeCode") {
            return this.entityTypeCode;
        }
        if (string == "defaultValue") {
            return this.defaultValue;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "emailTypeCode") {
            return this.emailTypeCode;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "emailAddress") {
            this.emailAddress = (String)object;
            return;
        }
        if (string == "entityTypeCode") {
            this.entityTypeCode = (String)object;
            return;
        }
        if (string == "defaultValue") {
            this.defaultValue = (Boolean)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "emailTypeCode") {
            this.emailTypeCode = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_emailAddress() {
        this._persistence_checkFetched("emailAddress");
        return this.emailAddress;
    }

    public void _persistence_set_emailAddress(String string) {
        this._persistence_checkFetchedForSet("emailAddress");
        this._persistence_propertyChange("emailAddress", this.emailAddress, string);
        this.emailAddress = string;
    }

    public String _persistence_get_entityTypeCode() {
        this._persistence_checkFetched("entityTypeCode");
        return this.entityTypeCode;
    }

    public void _persistence_set_entityTypeCode(String string) {
        this._persistence_checkFetchedForSet("entityTypeCode");
        this._persistence_propertyChange("entityTypeCode", this.entityTypeCode, string);
        this.entityTypeCode = string;
    }

    public boolean _persistence_get_defaultValue() {
        this._persistence_checkFetched("defaultValue");
        return this.defaultValue;
    }

    public void _persistence_set_defaultValue(boolean bl) {
        this._persistence_checkFetchedForSet("defaultValue");
        this._persistence_propertyChange("defaultValue", new Boolean(this.defaultValue), new Boolean(bl));
        this.defaultValue = bl;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public String _persistence_get_emailTypeCode() {
        this._persistence_checkFetched("emailTypeCode");
        return this.emailTypeCode;
    }

    public void _persistence_set_emailTypeCode(String string) {
        this._persistence_checkFetchedForSet("emailTypeCode");
        this._persistence_propertyChange("emailTypeCode", this.emailTypeCode, string);
        this.emailTypeCode = string;
    }
}

