/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.data.DataObjectService;

public class KimTypeInfoServiceImpl
implements KimTypeInfoService {
    protected DataObjectService dataObjectService;

    public KimType getKimType(String id) throws RiceIllegalArgumentException {
        this.incomingParamCheck(id, "id");
        return KimTypeBo.to((KimTypeBo)((Object)this.dataObjectService.find(KimTypeBo.class, (Object)id)));
    }

    public KimType findKimTypeByNameAndNamespace(String namespaceCode, String name) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(name, "name");
        HashMap<String, Object> crit = new HashMap<String, Object>(3);
        crit.put("namespaceCode", namespaceCode);
        crit.put("name", name);
        crit.put("active", Boolean.TRUE);
        QueryResults bos = this.dataObjectService.findMatching(KimTypeBo.class, QueryByCriteria.Builder.andAttributes(crit).build());
        if (bos.getResults().size() > 1) {
            throw new IllegalStateException("multiple active results were found for the namespace code: " + namespaceCode + " and name: " + name);
        }
        return bos.getResults().size() > 0 ? KimTypeBo.to((KimTypeBo)((Object)bos.getResults().get(0))) : null;
    }

    public Collection<KimType> findAllKimTypes() {
        QueryResults bos = this.dataObjectService.findMatching(KimTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build());
        ArrayList<KimType> ims = new ArrayList<KimType>(bos.getResults().size());
        for (KimTypeBo bo : bos.getResults()) {
            if (bo == null) continue;
            ims.add(KimTypeBo.to(bo));
        }
        return Collections.unmodifiableCollection(ims);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }
}

