/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.role;

public interface RoleInternalService {
    /**
	 * Notifies all of a principal's roles and role types that the principal has been inactivated.
	 */
	void principalInactivated(String principalId ) throws IllegalArgumentException;

	/**
	 * Notifies the role service that the role with the given id has been inactivated.
	 */
	void roleInactivated(String roleId) throws IllegalArgumentException;

	/**
	 * Notifies the role service that the group with the given id has been inactivated.
	 */
    void groupInactivated(String groupId) throws IllegalArgumentException;
}
