/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_ROLE_T")
public class RoleBo
extends DataObjectBase
implements RoleEbo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_ROLE_ID_S")
    @GeneratedValue(generator="KRIM_ROLE_ID_S")
    @Id
    @Column(name="ROLE_ID")
    private String id;
    @Column(name="ROLE_NM")
    private String name;
    @Column(name="DESC_TXT")
    private String description;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;
    @Column(name="KIM_TYP_ID")
    private String kimTypeId;
    @Column(name="NMSPC_CD")
    private String namespaceCode;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=RoleMemberBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ROLE_ID", referencedColumnName="ROLE_ID", insertable=false, updatable=false)
    private List<RoleMemberBo> members = new AutoPopulatingList(RoleMemberBo.class);
    @Transient
    private String principalName;
    @Transient
    private String groupNamespaceCode;
    @Transient
    private String groupName;
    @Transient
    private String permNamespaceCode;
    @Transient
    private String permName;
    @Transient
    private String permTmplNamespaceCode;
    @Transient
    private String permTmplName;
    @Transient
    private String respNamespaceCode;
    @Transient
    private String respName;
    @Transient
    private String respTmplNamespaceCode;
    @Transient
    private String respTmplName;
    @Transient
    private transient KimTypeInfoService kimTypeInfoService;

    protected List<String> getMembersOfType(String memberTypeCode) {
        ArrayList<String> roleMembers = new ArrayList<String>();
        for (RoleMemberBo member : this.getMembers()) {
            if (!member.getType().equals((Object)MemberType.valueOf((String)memberTypeCode)) || !member.isActive(new DateTime())) continue;
            roleMembers.add(member.getMemberId());
        }
        return roleMembers;
    }

    public KimTypeBo getKimRoleType() {
        if (this._persistence_get_kimTypeId() == null) {
            return null;
        }
        KimType type = this.getTypeInfoService().getKimType(this._persistence_get_kimTypeId());
        if (type == null) {
            return null;
        }
        return KimTypeBo.from(type);
    }

    protected KimTypeInfoService getTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }

    public static Role to(RoleBo bo) {
        if (bo == null) {
            return null;
        }
        return Role.Builder.create((RoleContract)bo).build();
    }

    public static RoleBo from(Role immutable) {
        if (immutable == null) {
            return null;
        }
        RoleBo bo = new RoleBo();
        bo._persistence_set_id(immutable.getId());
        bo._persistence_set_name(immutable.getName());
        bo._persistence_set_namespaceCode(immutable.getNamespaceCode());
        bo._persistence_set_description(immutable.getDescription());
        bo._persistence_set_kimTypeId(immutable.getKimTypeId());
        bo._persistence_set_active(immutable.isActive());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getKimTypeId() {
        return this._persistence_get_kimTypeId();
    }

    public void setKimTypeId(String kimTypeId) {
        this._persistence_set_kimTypeId(kimTypeId);
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public List<RoleMemberBo> getMembers() {
        return this._persistence_get_members();
    }

    public void setMembers(List<RoleMemberBo> members) {
        this._persistence_set_members(members);
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getGroupNamespaceCode() {
        return this.groupNamespaceCode;
    }

    public void setGroupNamespaceCode(String groupNamespaceCode) {
        this.groupNamespaceCode = groupNamespaceCode;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getPermNamespaceCode() {
        return this.permNamespaceCode;
    }

    public void setPermNamespaceCode(String permNamespaceCode) {
        this.permNamespaceCode = permNamespaceCode;
    }

    public String getPermName() {
        return this.permName;
    }

    public void setPermName(String permName) {
        this.permName = permName;
    }

    public String getPermTmplNamespaceCode() {
        return this.permTmplNamespaceCode;
    }

    public void setPermTmplNamespaceCode(String permTmplNamespaceCode) {
        this.permTmplNamespaceCode = permTmplNamespaceCode;
    }

    public String getPermTmplName() {
        return this.permTmplName;
    }

    public void setPermTmplName(String permTmplName) {
        this.permTmplName = permTmplName;
    }

    public String getRespNamespaceCode() {
        return this.respNamespaceCode;
    }

    public void setRespNamespaceCode(String respNamespaceCode) {
        this.respNamespaceCode = respNamespaceCode;
    }

    public String getRespName() {
        return this.respName;
    }

    public void setRespName(String respName) {
        this.respName = respName;
    }

    public String getRespTmplNamespaceCode() {
        return this.respTmplNamespaceCode;
    }

    public void setRespTmplNamespaceCode(String respTmplNamespaceCode) {
        this.respTmplNamespaceCode = respTmplNamespaceCode;
    }

    public String getRespTmplName() {
        return this.respTmplName;
    }

    public void setRespTmplName(String respTmplName) {
        this.respTmplName = respTmplName;
    }

    public void refresh() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RoleBo();
    }

    public Object _persistence_get(String string) {
        if (string == "kimTypeId") {
            return this.kimTypeId;
        }
        if (string == "members") {
            return this.members;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "kimTypeId") {
            this.kimTypeId = (String)object;
            return;
        }
        if (string == "members") {
            this.members = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_kimTypeId() {
        this._persistence_checkFetched("kimTypeId");
        return this.kimTypeId;
    }

    public void _persistence_set_kimTypeId(String string) {
        this._persistence_checkFetchedForSet("kimTypeId");
        this._persistence_propertyChange("kimTypeId", this.kimTypeId, string);
        this.kimTypeId = string;
    }

    public List _persistence_get_members() {
        this._persistence_checkFetched("members");
        return this.members;
    }

    public void _persistence_set_members(List list) {
        this._persistence_checkFetchedForSet("members");
        this._persistence_propertyChange("members", this.members, list);
        this.members = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }
}

