/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.phone;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.framework.identity.phone.EntityPhoneTypeEbo;
import org.kuali.rice.kim.impl.identity.CodedAttributeBo;

@AttributeOverrides({ @AttributeOverride(name = "code", column = @Column(name = "PHONE_TYP_CD")), @AttributeOverride(name = "name", column = @Column(name = "PHONE_TYP_NM")) })
@Entity
@Table(name = "KRIM_PHONE_TYP_T")
public class EntityPhoneTypeBo extends CodedAttributeBo implements EntityPhoneTypeEbo {

    private static final long serialVersionUID = -7999904356580992741L;

    public static EntityPhoneTypeBo from(CodedAttribute immutable) {
        return CodedAttributeBo.from(EntityPhoneTypeBo.class, immutable);
    }
}
