/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.employment;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name = "KRIM_ENTITY_EMP_INFO_T")
public class EntityEmploymentBo extends EntityEmploymentBase {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_ENTITY_EMP_ID_S")
    @GeneratedValue(generator = "KRIM_ENTITY_EMP_ID_S")
    @Id
    @Column(name = "ENTITY_EMP_ID")
    private String id;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityEmploymentTypeBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "EMP_TYP_CD", referencedColumnName = "EMP_TYP_CD", insertable = false, updatable = false)
    private EntityEmploymentTypeBo employeeType;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityEmploymentStatusBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "EMP_STAT_CD", referencedColumnName = "EMP_STAT_CD", insertable = false, updatable = false)
    private EntityEmploymentStatusBo employeeStatus;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityAffiliationBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "ENTITY_AFLTN_ID", referencedColumnName = "ENTITY_AFLTN_ID", insertable = false, updatable = false)
    private EntityAffiliationBo entityAffiliation;

    @Override
    public EntityAffiliationBo getEntityAffiliation() {
        return this.entityAffiliation;
    }

    @Override
    public EntityEmploymentStatusBo getEmployeeStatus() {
        return this.employeeStatus;
    }

    @Override
    public EntityEmploymentTypeBo getEmployeeType() {
        return this.employeeType;
    }

    public static EntityEmployment to(EntityEmploymentBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityEmployment.Builder.create(bo).build();
    }

    /**
     * Creates a EntityEmploymentBo business object from an immutable representation of a EntityEmployment.
     *
     * @param immutable an immutable EntityEmployment
     * @return a EntityEmploymentBo
     */
    public static EntityEmploymentBo from(EntityEmployment immutable) {
        if (immutable == null) {
            return null;
        }
        EntityEmploymentBo bo = new EntityEmploymentBo();
        bo.id = immutable.getId();
        bo.setActive(immutable.isActive());
        bo.setEntityId(immutable.getEntityId());
        if (immutable.getEmployeeType() != null) {
            bo.setEmployeeTypeCode(immutable.getEmployeeType().getCode());
            bo.setEmployeeType(EntityEmploymentTypeBo.from(immutable.getEmployeeType()));
        }
        if (immutable.getEmployeeStatus() != null) {
            bo.setEmployeeStatusCode(immutable.getEmployeeStatus().getCode());
            bo.setEmployeeStatus(EntityEmploymentStatusBo.from(immutable.getEmployeeStatus()));
        }
        if (immutable.getEntityAffiliation() != null) {
            bo.setEntityAffiliationId(immutable.getEntityAffiliation().getId());
            bo.setEntityAffiliation(EntityAffiliationBo.from(immutable.getEntityAffiliation()));
        }
        bo.setPrimaryDepartmentCode(immutable.getPrimaryDepartmentCode());
        bo.setEmployeeId(immutable.getEmployeeId());
        bo.setEmploymentRecordId(immutable.getEmploymentRecordId());
        bo.setBaseSalaryAmount(immutable.getBaseSalaryAmount());
        bo.setPrimary(immutable.isPrimary());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEmployeeType(EntityEmploymentTypeBo employeeType) {
        this.employeeType = employeeType;
    }

    public void setEmployeeStatus(EntityEmploymentStatusBo employeeStatus) {
        this.employeeStatus = employeeStatus;
    }

    public void setEntityAffiliation(EntityAffiliationBo entityAffiliation) {
        this.entityAffiliation = entityAffiliation;
    }
}
