/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.permission;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_PERM_T")
public class PermissionBo
extends PersistableBusinessObjectBase
implements PermissionContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_PERM_ID_S")
    @GeneratedValue(generator="KRIM_PERM_ID_S")
    @Id
    @Column(name="PERM_ID")
    protected String id;
    @Column(name="NMSPC_CD")
    protected String namespaceCode;
    @Column(name="NM")
    protected String name;
    @Column(name="DESC_TXT")
    protected String description;
    @Column(name="PERM_TMPL_ID")
    protected String templateId;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    protected boolean active;
    @JoinFetch(value=JoinFetchType.OUTER)
    @ManyToOne(targetEntity=PermissionTemplateBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PERM_TMPL_ID", referencedColumnName="PERM_TMPL_ID", insertable=false, updatable=false)
    protected PermissionTemplateBo template = new PermissionTemplateBo();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PermissionAttributeBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PERM_ID", referencedColumnName="PERM_ID")
    protected List<PermissionAttributeBo> attributeDetails;
    @Transient
    protected Map<String, String> attributes;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(mappedBy="permission")
    @JoinColumn(name="PERM_ID", referencedColumnName="PERM_ID", insertable=false, updatable=false)
    protected List<RolePermissionBo> rolePermissions = new AutoPopulatingList(RolePermissionBo.class);

    public Map<String, String> getAttributes() {
        return this._persistence_get_attributeDetails() != null ? KimAttributeDataBo.toAttributes(this._persistence_get_attributeDetails()) : this.attributes;
    }

    public Map<String, String> getDetails() {
        return this._persistence_get_attributeDetails() != null ? KimAttributeDataBo.toAttributes(this._persistence_get_attributeDetails()) : this.attributes;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getTemplateId() {
        return this._persistence_get_templateId();
    }

    public void setTemplateId(String templateId) {
        this._persistence_set_templateId(templateId);
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public List<PermissionAttributeBo> getAttributeDetails() {
        return this._persistence_get_attributeDetails();
    }

    public void setAttributeDetails(List<PermissionAttributeBo> attributeDetails) {
        this._persistence_set_attributeDetails(attributeDetails);
    }

    public List<RolePermissionBo> getRolePermissions() {
        return this._persistence_get_rolePermissions();
    }

    public void setRolePermissions(List<RolePermissionBo> rolePermissions) {
        this._persistence_set_rolePermissions(rolePermissions);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public static Permission to(PermissionBo bo) {
        if (bo == null) {
            return null;
        }
        return Permission.Builder.create((PermissionContract)bo).build();
    }

    public static PermissionBo from(Permission im) {
        if (im == null) {
            return null;
        }
        PermissionBo bo = new PermissionBo();
        bo.setId(im.getId());
        bo.setNamespaceCode(im.getNamespaceCode());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setActive(im.isActive());
        bo.setTemplateId(im.getTemplate() != null ? im.getTemplate().getId() : null);
        bo.setTemplate(PermissionTemplateBo.from(im.getTemplate()));
        bo.setAttributes(im.getAttributes());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public PermissionTemplateBo getTemplate() {
        return this._persistence_get_template();
    }

    public void setTemplate(PermissionTemplateBo template) {
        this._persistence_set_template(template);
    }

    public String getDetailObjectsValues() {
        StringBuffer detailObjectsToDisplayBuffer = new StringBuffer();
        Iterator permIter = this._persistence_get_attributeDetails().iterator();
        while (permIter.hasNext()) {
            PermissionAttributeBo permissionAttributeData = (PermissionAttributeBo)((Object)permIter.next());
            detailObjectsToDisplayBuffer.append(permissionAttributeData.getAttributeValue());
            if (!permIter.hasNext()) continue;
            detailObjectsToDisplayBuffer.append(", ");
        }
        return detailObjectsToDisplayBuffer.toString();
    }

    public String getDetailObjectsToDisplay() {
        KimType kimType = this.getTypeInfoService().getKimType(this.getTemplate().getKimTypeId());
        StringBuffer detailObjects = new StringBuffer();
        Iterator permIter = this._persistence_get_attributeDetails().iterator();
        while (permIter.hasNext()) {
            PermissionAttributeBo bo = (PermissionAttributeBo)((Object)permIter.next());
            detailObjects.append(this.getKimAttributeLabelFromDD(kimType.getAttributeDefinitionById(bo.getKimAttributeId()))).append(":").append(bo.getAttributeValue());
            if (!permIter.hasNext()) continue;
            detailObjects.append(", ");
        }
        return detailObjects.toString();
    }

    private String getKimAttributeLabelFromDD(KimTypeAttribute attribute) {
        return this.getDataDictionaryService().getAttributeLabel(attribute.getKimAttribute().getComponentName(), attribute.getKimAttribute().getAttributeName());
    }

    private DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    private KimTypeInfoService getTypeInfoService() {
        return KimApiServiceLocator.getKimTypeInfoService();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PermissionBo();
    }

    public Object _persistence_get(String string) {
        if (string == "template") {
            return this.template;
        }
        if (string == "rolePermissions") {
            return this.rolePermissions;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "attributeDetails") {
            return this.attributeDetails;
        }
        if (string == "templateId") {
            return this.templateId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "template") {
            this.template = (PermissionTemplateBo)((Object)object);
            return;
        }
        if (string == "rolePermissions") {
            this.rolePermissions = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "attributeDetails") {
            this.attributeDetails = (List)object;
            return;
        }
        if (string == "templateId") {
            this.templateId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public PermissionTemplateBo _persistence_get_template() {
        this._persistence_checkFetched("template");
        return this.template;
    }

    public void _persistence_set_template(PermissionTemplateBo permissionTemplateBo) {
        this._persistence_checkFetchedForSet("template");
        this._persistence_propertyChange("template", (Object)this.template, (Object)permissionTemplateBo);
        this.template = permissionTemplateBo;
    }

    public List _persistence_get_rolePermissions() {
        this._persistence_checkFetched("rolePermissions");
        return this.rolePermissions;
    }

    public void _persistence_set_rolePermissions(List list) {
        this._persistence_checkFetchedForSet("rolePermissions");
        this._persistence_propertyChange("rolePermissions", this.rolePermissions, list);
        this.rolePermissions = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }

    public List _persistence_get_attributeDetails() {
        this._persistence_checkFetched("attributeDetails");
        return this.attributeDetails;
    }

    public void _persistence_set_attributeDetails(List list) {
        this._persistence_checkFetchedForSet("attributeDetails");
        this._persistence_propertyChange("attributeDetails", this.attributeDetails, list);
        this.attributeDetails = list;
    }

    public String _persistence_get_templateId() {
        this._persistence_checkFetched("templateId");
        return this.templateId;
    }

    public void _persistence_set_templateId(String string) {
        this._persistence_checkFetchedForSet("templateId");
        this._persistence_propertyChange("templateId", this.templateId, string);
        this.templateId = string;
    }
}

