/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class CodedAttributeBo extends DataObjectBase implements CodedAttributeContract {
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(CodedAttributeBo.class);
    private static final long serialVersionUID = -5023039880648352464L;
    @Id
    @Column(name = "CD")
    private String code;
    @Column(name = "NM")
    private String name;
    @javax.persistence.Convert(converter=BooleanYNConverter.class)
    @Column(name = "ACTV_IND")
    private boolean active;
    @Column(name = "DISPLAY_SORT_CD")
    private String sortCode;

    /**
     * Converts a mutable extension CodedAttributeBo to an immutable CodedAttribute representation.
     *
     * @param bo
     * @return an immutable EntityCitizenshipChangeType
     */
    public static <T extends CodedAttributeBo>CodedAttribute to(T bo) {
        if (bo == null) {
            return null;
        }

        return CodedAttribute.Builder.create(bo).build();
    }

    /**
     * Creates a EntityCitizenshipChangeTypeBo business object from an immutable representation of a
     * EntityCitizenshipChangeType.
     *
     * @param immutable an immutable CodedAttribute
     * @return an object extending from CodedAttributeBo
     */
    public static <T extends CodedAttributeBo> T from(Class<T> type, CodedAttribute immutable) {
        if (immutable == null) {
            return null;
        }
        T bo = null;
        try {
            bo = type.newInstance();

            bo.setCode(immutable.getCode());
            bo.setName(immutable.getName());
            bo.setSortCode(immutable.getSortCode());
            bo.setActive(immutable.isActive());
            bo.setVersionNumber(immutable.getVersionNumber());
            bo.setObjectId(immutable.getObjectId());
        } catch (InstantiationException e) {
            LOG.error(e.getMessage(), e);
        } catch (IllegalAccessException e) {
            LOG.error(e.getMessage(), e);
        }
        return bo;
    }

    @Override
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getSortCode() {
        return sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public void refresh() {
    }

}
