/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.services;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.impl.group.GroupInternalService;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.role.RoleInternalService;
import org.springframework.cache.CacheManager;

import javax.sql.DataSource;
import javax.xml.namespace.QName;

public class KimImplServiceLocator {
    private static final Logger LOG = LogManager.getLogger(KimImplServiceLocator.class);

    public static final String KIM_RUN_MODE_PROPERTY = "kim.mode";
    public static final String RESPONSIBILITY_INTERNAL_SERVICE = "responsibilityInternalService";
    public static final String GROUP_INTERNAL_SERVICE = "groupInternalService";
    public static final String ROLE_INTERNAL_SERVICE = "kimRoleInternalService";
    public static final String LOCAL_CACHE_MANAGER = "kimLocalCacheManager";
    public static final String DEFAULT_ROLE_TYPE_SERVICE = "kimRoleTypeService";

    public static final String KIM_ROLE_DAO = "kimRoleDao";
    public static final String KIM_DATA_SOURCE = "kimDataSource";

    public static Object getService(String serviceName) {
        return getBean(serviceName);
    }

    public static Object getBean(String serviceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching service " + serviceName);
        }
        QName name = new QName(serviceName);
        RunMode kimRunMode = RunMode.valueOf(ConfigContext.getCurrentContextConfig().getProperty(KIM_RUN_MODE_PROPERTY));
        if (kimRunMode == RunMode.REMOTE || kimRunMode == RunMode.THIN) {
            name = new QName(KimConstants.KIM_MODULE_NAMESPACE, serviceName);
        }
        return GlobalResourceLoader.getResourceLoader().getService(name);
    }

    public static ResponsibilityInternalService getResponsibilityInternalService() {
        return (ResponsibilityInternalService) getService(RESPONSIBILITY_INTERNAL_SERVICE);
    }

    public static GroupInternalService getGroupInternalService() {
        return (GroupInternalService) getService(GROUP_INTERNAL_SERVICE);
    }

    public static RoleInternalService getRoleInternalService() {
        return (RoleInternalService) getService(ROLE_INTERNAL_SERVICE);
    }

    public static CacheManager getLocalCacheManager() {
        return (CacheManager) getService(LOCAL_CACHE_MANAGER);
    }

    public static RoleTypeService getDefaultRoleTypeService() {
        return (RoleTypeService) getService(DEFAULT_ROLE_TYPE_SERVICE);
    }

    public static RoleDao getRoleDao() {
        return (RoleDao) getService(KIM_ROLE_DAO);
    }

    public static DataSource getDataSource() {
        return (DataSource)getService(KIM_DATA_SOURCE);
    }
}
